"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldDetail = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _advanced_parameters_section = require("./advanced_parameters_section");
var _form_row = require("./form_row");
var _form_fields = require("./form_fields");
var _field_editor_context = require("../field_editor_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_field_editor/public/components/field_editor/field_detail.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const geti18nTexts = () => ({
  customLabel: {
    title: _i18n.i18n.translate('indexPatternFieldEditor.editor.form.customLabelTitle', {
      defaultMessage: 'Set custom label'
    }),
    description: _i18n.i18n.translate('indexPatternFieldEditor.editor.form.customLabelDescription', {
      defaultMessage: `Create a label to display in place of the field name in Discover, Maps, Lens, Visualize, and TSVB. Useful for shortening a long field name. Queries and filters use the original field name.`
    })
  },
  customDescription: {
    title: _i18n.i18n.translate('indexPatternFieldEditor.editor.form.customDescriptionTitle', {
      defaultMessage: 'Set custom description'
    }),
    description: _i18n.i18n.translate('indexPatternFieldEditor.editor.form.customDescriptionDescription', {
      defaultMessage: "Add a description to the field. It's displayed next to the field on the Discover, Lens, and Data View Management pages."
    })
  },
  value: {
    title: _i18n.i18n.translate('indexPatternFieldEditor.editor.form.valueTitle', {
      defaultMessage: 'Set value'
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternFieldEditor.editor.form.valueDescription",
      defaultMessage: "Set a value for the field instead of retrieving it from the field with the same name in {source}.",
      values: {
        source: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 57,
            columnNumber: 19
          }
        }, '_source')
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 7
      }
    })
  },
  format: {
    title: _i18n.i18n.translate('indexPatternFieldEditor.editor.form.formatTitle', {
      defaultMessage: 'Set format'
    }),
    description: _i18n.i18n.translate('indexPatternFieldEditor.editor.form.formatDescription', {
      defaultMessage: `Set your preferred format for displaying the value. Changing the format can affect the value and prevent highlighting in Discover.`
    })
  },
  popularity: {
    title: _i18n.i18n.translate('indexPatternFieldEditor.editor.form.popularityTitle', {
      defaultMessage: 'Set popularity'
    }),
    description: _i18n.i18n.translate('indexPatternFieldEditor.editor.form.popularityDescription', {
      defaultMessage: `Adjust the popularity to make the field appear higher or lower in the fields list.  By default, Discover orders fields from most selected to least selected.`
    })
  }
});
const FieldDetail = ({
  isDisabled
}) => {
  const {
    links,
    fieldTypeToProcess
  } = (0, _field_editor_context.useFieldEditorContext)();
  const i18nTexts = geti18nTexts();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_form_row.FormRow, {
    title: i18nTexts.customLabel.title,
    description: i18nTexts.customLabel.description,
    disabled: isDisabled,
    formFieldPath: "__meta__.isCustomLabelVisible",
    "data-test-subj": "customLabelRow",
    withDividerRule: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_form_fields.CustomLabelField, {
    disabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_form_row.FormRow, {
    title: i18nTexts.customDescription.title,
    description: i18nTexts.customDescription.description,
    disabled: isDisabled,
    formFieldPath: "__meta__.isCustomDescriptionVisible",
    "data-test-subj": "customDescriptionRow",
    withDividerRule: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_form_fields.CustomDescriptionField, {
    disabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  })), fieldTypeToProcess === 'runtime' && /*#__PURE__*/_react.default.createElement(_form_row.FormRow, {
    title: i18nTexts.value.title,
    description: i18nTexts.value.description,
    disabled: isDisabled,
    formFieldPath: "__meta__.isValueVisible",
    "data-test-subj": "valueRow",
    withDividerRule: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_form_fields.ScriptField, {
    links: links,
    disabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_form_row.FormRow, {
    title: i18nTexts.format.title,
    description: i18nTexts.format.description,
    disabled: isDisabled,
    formFieldPath: "__meta__.isFormatVisible",
    "data-test-subj": "formatRow",
    withDividerRule: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_form_fields.FormatField, {
    disabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_advanced_parameters_section.AdvancedParametersSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_form_row.FormRow, {
    title: i18nTexts.popularity.title,
    description: i18nTexts.popularity.description,
    disabled: isDisabled,
    formFieldPath: "__meta__.isPopularityVisible",
    "data-test-subj": "popularityRow",
    withDividerRule: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_form_fields.PopularityField, {
    disabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  }))));
};
exports.FieldDetail = FieldDetail;