"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.gridDataSchema = exports.dashboardAttributesSchema = exports.controlGroupInputSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _v = require("../v1");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const controlGroupInputSchema = exports.controlGroupInputSchema = _v.controlGroupInputSchema.extends({
  showApplySelections: _configSchema.schema.maybe(_configSchema.schema.boolean())
}, {
  unknowns: 'ignore'
});
const dashboardAttributesSchema = exports.dashboardAttributesSchema = _v.dashboardAttributesSchema.extends({
  controlGroupInput: _configSchema.schema.maybe(controlGroupInputSchema)
}, {
  unknowns: 'ignore'
});
const gridDataSchema = exports.gridDataSchema = _configSchema.schema.object({
  x: _configSchema.schema.number(),
  y: _configSchema.schema.number(),
  w: _configSchema.schema.number(),
  h: _configSchema.schema.number(),
  i: _configSchema.schema.string()
});