"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserBannerService = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _rxjs = require("rxjs");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/overlays/browser-internal/src/banners/user_banner_service.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ReactMarkdownLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('react-markdown'))));

/**
 * Sets up the custom banner that can be specified in advanced settings.
 * @internal
 */
class UserBannerService {
  constructor() {
    (0, _defineProperty2.default)(this, "settingsSubscription", void 0);
  }
  start({
    banners,
    uiSettings,
    ...startServices
  }) {
    let id;
    let timeout;
    const dismiss = () => {
      banners.remove(id);
      clearTimeout(timeout);
    };
    const updateBanner = () => {
      const content = uiSettings.get('notifications:banner');
      const lifetime = uiSettings.get('notifications:lifetime:banner');
      if (typeof content !== 'string' || content.length === 0 || typeof lifetime !== 'number') {
        dismiss();
        return;
      }
      id = banners.replace(id, el => {
        _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, startServices, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 69,
            columnNumber: 13
          }
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
          title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "core.ui.overlays.banner.attentionTitle",
            defaultMessage: "Attention",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 72,
              columnNumber: 19
            }
          }),
          iconType: "question",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 70,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
          fallback: /*#__PURE__*/_react.default.createElement("div", {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 81,
              columnNumber: 21
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 82,
              columnNumber: 23
            }
          })),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 79,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(ReactMarkdownLazy, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 86,
            columnNumber: 19
          }
        }, content.trim())), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
          color: "primary",
          size: "s",
          onClick: () => banners.remove(id),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 89,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "core.ui.overlays.banner.closeButtonLabel",
          defaultMessage: "Close",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 90,
            columnNumber: 19
          }
        })))), el);
        timeout = setTimeout(dismiss, lifetime);
        return () => _reactDom.default.unmountComponentAtNode(el);
      }, 100);
    };
    updateBanner();
    this.settingsSubscription = uiSettings.getUpdate$().pipe((0, _rxjs.filter)(({
      key
    }) => key === 'notifications:banner' || key === 'notifications:lifetime:banner')).subscribe(() => updateBanner());
  }
  stop() {
    if (this.settingsSubscription) {
      this.settingsSubscription.unsubscribe();
      this.settingsSubscription = undefined;
    }
  }
}
exports.UserBannerService = UserBannerService;