"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RGBPicker = RGBPicker;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _chromaJs = _interopRequireDefault(require("chroma-js"));
var _react2 = require("@emotion/react");
var _uiTheme = require("@kbn/ui-theme");
var _i18n = require("@kbn/i18n");
var _color_math = require("../../color/color_math");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-coloring/src/shared_components/color_mapping/components/color_picker/rgb_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function RGBPicker({
  color,
  palettes,
  selectColor
}) {
  const [customColorMappingColor, setCustomColorMappingColor] = (0, _react.useState)(color);
  const customColorHex = customColorMappingColor.type === 'categorical' ? palettes.get(customColorMappingColor.paletteId).getColor(customColorMappingColor.colorIndex) : customColorMappingColor.colorCode;
  const [colorTextInput, setColorTextInput] = (0, _react.useState)(customColorHex);

  // check contrasts with WCAG 2.1 with a min contrast ratio of 3
  const lightContrast = (0, _color_math.hasEnoughContrast)(customColorHex, false, 3);
  const darkContrast = (0, _color_math.hasEnoughContrast)(customColorHex, true, 3);
  const errorMessage = [lightContrast === false ? 'light' : undefined, darkContrast === false ? 'dark' : undefined].filter(Boolean);
  const isColorTextInvalid = !_chromaJs.default.valid(colorTextInput);
  const colorHasLowContrast = !lightContrast || !darkContrast;

  // debounce setting the color from the rgb picker by 500ms
  (0, _useDebounce.default)(() => {
    if (color !== customColorMappingColor) {
      selectColor(customColorMappingColor);
    }
  }, 500, [color, customColorMappingColor]);
  const invalidColor = isColorTextInvalid ? _uiTheme.euiThemeVars.euiColorDanger : colorHasLowContrast ? _uiTheme.euiThemeVars.euiColorWarning : '';
  const invalidColorText = isColorTextInvalid ? _uiTheme.euiThemeVars.euiColorDangerText : colorHasLowContrast ? _uiTheme.euiThemeVars.euiColorWarningText : '';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    css: {
      padding: 8
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
    onChange: c => {
      setCustomColorMappingColor({
        type: 'colorCode',
        colorCode: c
      });
      setColorTextInput(c);
    },
    color: customColorHex,
    display: "inline",
    swatches: [],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: isColorTextInvalid || colorHasLowContrast ? (0, _react2.css)`
                  input {
                    background-image: linear-gradient(
                      to top,
                      ${invalidColor},
                      ${invalidColor} 2px,
                      transparent 2px,
                      transparent 100%
                    ) !important;
                    background-size: 100%;
                    padding-right: 32px;
                  }
                  .euiFormErrorText {
                    color: ${invalidColorText} !important;
                  }
                ` : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react2.css)`
                position: relative;
              `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: "#FF00FF",
    value: colorTextInput,
    compressed: true,
    onChange: e => {
      const textColor = e.currentTarget.value;
      setColorTextInput(textColor);
      if (_chromaJs.default.valid(textColor)) {
        setCustomColorMappingColor({
          type: 'colorCode',
          colorCode: textColor
        });
      }
    },
    "data-test-subj": "lns-colorMapping-colorPicker-custom-input",
    "aria-label": _i18n.i18n.translate('coloring.colorMapping.colorPicker.hexColorinputAriaLabel', {
      defaultMessage: 'hex color input'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 17
    }
  })), (isColorTextInvalid || colorHasLowContrast) && /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
                    position: absolute;
                    right: 8px;
                    top: 6px;
                  `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    position: "bottom",
    content: isColorTextInvalid ? _i18n.i18n.translate('coloring.colorMapping.colorPicker.invalidColorHex', {
      defaultMessage: 'Please use a valid color hex code'
    }) : colorHasLowContrast ? _i18n.i18n.translate('coloring.colorMapping.colorPicker.lowContrastColor', {
      defaultMessage: `This color has a low contrast in {themes} {errorModes, plural, one {mode} other {# modes}}`,
      values: {
        themes: errorMessage.join(','),
        errorModes: errorMessage.length
      }
    }) : undefined,
    type: "warning",
    color: isColorTextInvalid ? _uiTheme.euiThemeVars.euiColorDangerText : colorHasLowContrast ? _uiTheme.euiThemeVars.euiColorWarningText : _uiTheme.euiThemeVars.euiColorPrimary,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 19
    }
  })))))));
}