"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getErrorSampleDetails = getErrorSampleDetails;
var _server = require("@kbn/observability-plugin/server");
var _utils = require("@kbn/apm-data-access-plugin/server/utils");
var _as_mutable_array = require("../../../../common/utils/as_mutable_array");
var _maybe = require("../../../../common/utils/maybe");
var _apm = require("../../../../common/es_fields/apm");
var _environment_query = require("../../../../common/utils/environment_query");
var _document_type = require("../../../../common/document_type");
var _rollup = require("../../../../common/rollup");
var _get_transaction = require("../../transactions/get_transaction");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getErrorSampleDetails({
  environment,
  kuery,
  serviceName,
  errorId,
  apmEventClient,
  start,
  end
}) {
  var _errorFromFields$tran, _errorFromFields$tran2, _errorFromFields$span, _errorFromFields$trac, _errorFromFields$erro, _errorFromFields$erro2, _source$error$excepti, _source$error$excepti2, _source$error;
  const requiredFields = (0, _as_mutable_array.asMutableArray)([_apm.ID, _apm.AGENT_NAME, _apm.PROCESSOR_EVENT, _apm.TIMESTAMP_US, _apm.AT_TIMESTAMP, _apm.SERVICE_NAME, _apm.ERROR_GROUP_ID]);
  const optionalFields = (0, _as_mutable_array.asMutableArray)([_apm.TRACE_ID, _apm.TRANSACTION_ID, _apm.SPAN_ID, _apm.AGENT_VERSION, _apm.PROCESSOR_NAME, _apm.SERVICE_LANGUAGE_NAME, _apm.ERROR_CULPRIT, _apm.ERROR_STACK_TRACE, _apm.ERROR_EXC_MESSAGE, _apm.ERROR_EXC_HANDLED, _apm.ERROR_EXC_TYPE, _apm.ERROR_ID, _apm.URL_FULL, _apm.HTTP_REQUEST_METHOD, _apm.HTTP_RESPONSE_STATUS_CODE, _apm.TRANSACTION_PAGE_URL, _apm.USER_AGENT_NAME, _apm.USER_AGENT_VERSION]);
  const params = {
    apm: {
      sources: [{
        documentType: _document_type.ApmDocumentType.ErrorEvent,
        rollupInterval: _rollup.RollupInterval.None
      }]
    },
    track_total_hits: false,
    size: 1,
    query: {
      bool: {
        filter: [{
          term: {
            [_apm.SERVICE_NAME]: serviceName
          }
        }, ...(0, _server.rangeQuery)(start, end), ...(0, _environment_query.environmentQuery)(environment), ...(0, _server.kqlQuery)(kuery), {
          bool: {
            should: [...(0, _server.termQuery)(_apm.ERROR_ID, errorId), ...(0, _server.termQuery)(_apm.ID, errorId)],
            minimum_should_match: 1
          }
        }]
      }
    },
    fields: [...requiredFields, ...optionalFields],
    _source: [_apm.ERROR_EXCEPTION, 'error.log']
  };
  const resp = await apmEventClient.search('get_error_sample_details', params);
  const hit = (0, _maybe.maybe)(resp.hits.hits[0]);
  if (!hit) {
    return {
      transaction: undefined,
      error: undefined
    };
  }
  const source = 'error' in hit._source ? hit._source : undefined;
  const errorFromFields = (0, _utils.unflattenKnownApmEventFields)(hit.fields, requiredFields);
  const transactionId = (_errorFromFields$tran = (_errorFromFields$tran2 = errorFromFields.transaction) === null || _errorFromFields$tran2 === void 0 ? void 0 : _errorFromFields$tran2.id) !== null && _errorFromFields$tran !== void 0 ? _errorFromFields$tran : (_errorFromFields$span = errorFromFields.span) === null || _errorFromFields$span === void 0 ? void 0 : _errorFromFields$span.id;
  const traceId = (_errorFromFields$trac = errorFromFields.trace) === null || _errorFromFields$trac === void 0 ? void 0 : _errorFromFields$trac.id;
  let transaction;
  if (transactionId && traceId) {
    transaction = await (0, _get_transaction.getTransaction)({
      transactionId,
      traceId,
      apmEventClient,
      start,
      end
    });
  }
  return {
    transaction,
    error: {
      ...errorFromFields,
      processor: {
        name: errorFromFields.processor.name,
        event: errorFromFields.processor.event
      },
      error: {
        ...errorFromFields.error,
        id: (_errorFromFields$erro = (_errorFromFields$erro2 = errorFromFields.error) === null || _errorFromFields$erro2 === void 0 ? void 0 : _errorFromFields$erro2.id) !== null && _errorFromFields$erro !== void 0 ? _errorFromFields$erro : errorFromFields[_apm.ID],
        exception: ((_source$error$excepti = source === null || source === void 0 ? void 0 : (_source$error$excepti2 = source.error.exception) === null || _source$error$excepti2 === void 0 ? void 0 : _source$error$excepti2.length) !== null && _source$error$excepti !== void 0 ? _source$error$excepti : 0) > 0 ? source === null || source === void 0 ? void 0 : source.error.exception : (errorFromFields === null || errorFromFields === void 0 ? void 0 : errorFromFields.error.exception) && [errorFromFields.error.exception],
        log: source === null || source === void 0 ? void 0 : (_source$error = source.error) === null || _source$error === void 0 ? void 0 : _source$error.log
      }
    }
  };
}