"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerlessSummary = ServerlessSummary;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _formatters = require("../../../../../common/utils/formatters");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_breakpoints = require("../../../../hooks/use_breakpoints");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_time_range = require("../../../../hooks/use_time_range");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/metrics/serverless_metrics/serverless_summary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CentralizedContainer = _styled.default.div`
  display: flex;
  align-items: center;
`;
const Border = _styled.default.div`
  height: 55px;
  border-right: ${({
  theme
}) => theme.euiTheme.border.thin};
`;
function VerticalRule() {
  return /*#__PURE__*/_react.default.createElement(CentralizedContainer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(Border, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }));
}
function ServerlessSummary({
  serverlessId
}) {
  const breakpoints = (0, _use_breakpoints.useBreakpoints)();
  const {
    query: {
      environment,
      kuery,
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/metrics');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!start || !end) {
      return undefined;
    }
    return callApmApi('GET /internal/apm/services/{serviceName}/metrics/serverless/summary', {
      params: {
        path: {
          serviceName
        },
        query: {
          kuery,
          environment,
          start,
          end,
          serverlessId
        }
      }
    });
  }, [kuery, environment, serviceName, start, end, serverlessId]);
  const showVerticalRule = !breakpoints.isSmall;
  const isLoading = status === _use_fetcher.FETCH_STATUS.LOADING;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.serverlessMetrics.summary.title', {
    defaultMessage: 'Summary'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "apmServerlessSummaryGiveFeedbackLink",
    href: "https://ela.st/feedback-aws-lambda",
    target: "_blank",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.apm.serverlessMetrics.summary.feedback', {
    defaultMessage: 'Give feedback'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    isLoading: isLoading,
    title: data === null || data === void 0 ? void 0 : data.serverlessFunctionsTotal,
    titleSize: "s",
    description: _i18n.i18n.translate('xpack.apm.serverlessMetrics.summary.lambdaFunctions', {
      defaultMessage: 'Lambda {serverlessFunctionsTotal, plural, one {function} other {functions}}',
      values: {
        serverlessFunctionsTotal: data === null || data === void 0 ? void 0 : data.serverlessFunctionsTotal
      }
    }),
    reverse: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  })), showVerticalRule && /*#__PURE__*/_react.default.createElement(VerticalRule, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 30
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    isLoading: isLoading,
    title: (0, _formatters.asMillisecondDuration)(data === null || data === void 0 ? void 0 : data.serverlessDurationAvg),
    titleSize: "s",
    description: _i18n.i18n.translate('xpack.apm.serverlessMetrics.summary.functionDurationAvg', {
      defaultMessage: 'Function duration avg.'
    }),
    reverse: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    isLoading: isLoading,
    title: (0, _formatters.asMillisecondDuration)(data === null || data === void 0 ? void 0 : data.billedDurationAvg),
    titleSize: "s",
    description: _i18n.i18n.translate('xpack.apm.serverlessMetrics.summary.billedDurationAvg', {
      defaultMessage: 'Billed duration avg.'
    }),
    reverse: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    isLoading: isLoading,
    title: (0, _formatters.asPercent)(data === null || data === void 0 ? void 0 : data.memoryUsageAvgRate, 1),
    titleSize: "s",
    description: _i18n.i18n.translate('xpack.apm.serverlessMetrics.summary.memoryUsageAvg', {
      defaultMessage: 'Memory usage avg.'
    }),
    reverse: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 11
    }
  })), showVerticalRule && /*#__PURE__*/_react.default.createElement(VerticalRule, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 30
    }
  }), (data === null || data === void 0 ? void 0 : data.estimatedCost) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    isLoading: isLoading,
    title: `$${data.estimatedCost}`,
    titleSize: "s",
    description: _i18n.i18n.translate('xpack.apm.serverlessMetrics.summary.estimatedCost', {
      defaultMessage: 'Estimated costs avg.'
    }),
    reverse: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 13
    }
  }))));
}