"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogRateAnalysisAttachmentsMenu = void 0;
var _public = require("@kbn/presentation-util-plugin/public");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _react = _interopRequireWildcard(require("react"));
var _mlDatePicker = require("@kbn/ml-date-picker");
var _constants = require("@kbn/aiops-log-rate-analysis/constants");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants2 = require("../../../cases/constants");
var _use_cases_modal = require("../../../hooks/use_cases_modal");
var _use_data_source = require("../../../hooks/use_data_source");
var _use_aiops_app_context = require("../../../hooks/use_aiops_app_context");
var _get_dataview_references = require("../../../embeddables/get_dataview_references");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/log_rate_analysis/log_rate_analysis_content/log_rate_analysis_attachments_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SavedObjectSaveModalDashboard = (0, _sharedUxUtility.withSuspense)(_public.LazySavedObjectSaveModalDashboard);
const LogRateAnalysisAttachmentsMenu = ({
  windowParameters,
  showLogRateAnalysisResults,
  significantItems
}) => {
  var _cases$helpers$canUse, _cases$helpers, _panels$, _panels$$items;
  const {
    application: {
      capabilities
    },
    cases,
    embeddable
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const {
    dataView
  } = (0, _use_data_source.useDataSource)();
  const [applyTimeRange, setApplyTimeRange] = (0, _react.useState)(false);
  const [isActionMenuOpen, setIsActionMenuOpen] = (0, _react.useState)(false);
  const [dashboardAttachmentReady, setDashboardAttachmentReady] = (0, _react.useState)(false);
  const timeRange = (0, _mlDatePicker.useTimeRangeUpdates)();
  const absoluteTimeRange = (0, _mlDatePicker.useTimeRangeUpdates)(true);
  const openCasesModalCallback = (0, _use_cases_modal.useCasesModal)(_constants.EMBEDDABLE_LOG_RATE_ANALYSIS_TYPE, _constants2.CASES_TOAST_MESSAGES_TITLES.LOG_RATE_ANALYSIS);
  const canEditDashboards = capabilities.dashboard_v2.createNew;
  const {
    create: canCreateCase,
    update: canUpdateCase
  } = (_cases$helpers$canUse = cases === null || cases === void 0 ? void 0 : (_cases$helpers = cases.helpers) === null || _cases$helpers === void 0 ? void 0 : _cases$helpers.canUseCases()) !== null && _cases$helpers$canUse !== void 0 ? _cases$helpers$canUse : {
    create: false,
    update: false
  };
  const isCasesAttachmentEnabled = showLogRateAnalysisResults && significantItems.length > 0;
  const onSave = (0, _react.useCallback)(async ({
    dashboardId,
    newTitle,
    newDescription
  }) => {
    const stateTransfer = embeddable.getStateTransfer();
    const embeddableInput = {
      title: newTitle,
      description: newDescription,
      dataViewId: dataView.id,
      hidePanelTitles: false,
      ...(applyTimeRange && {
        timeRange
      })
    };
    const state = {
      serializedState: {
        rawState: embeddableInput,
        references: (0, _get_dataview_references.getDataviewReferences)(dataView.id, _constants.LOG_RATE_ANALYSIS_DATA_VIEW_REF_NAME)
      },
      type: _constants.EMBEDDABLE_LOG_RATE_ANALYSIS_TYPE
    };
    const path = dashboardId === 'new' ? '#/create' : `#/view/${dashboardId}`;
    stateTransfer.navigateToWithEmbeddablePackage('dashboards', {
      state,
      path
    });
  }, [dataView.id, embeddable, applyTimeRange, timeRange]);
  const caseAttachmentTooltipContent = (0, _react.useMemo)(() => {
    if (!showLogRateAnalysisResults) {
      return _i18n.i18n.translate('xpack.aiops.logRateAnalysis.attachToCaseTooltipNoAnalysis', {
        defaultMessage: 'Run the analysis first to add results to a case.'
      });
    }
    if (significantItems.length === 0) {
      return _i18n.i18n.translate('xpack.aiops.logRateAnalysis.attachToCaseTooltipNoResults', {
        defaultMessage: 'Cannot add to case because the analysis did not produce any results.'
      });
    }
  }, [showLogRateAnalysisResults, significantItems.length]);
  const panels = (0, _react.useMemo)(() => {
    return [{
      id: 'attachMainPanel',
      size: 's',
      items: [...(canEditDashboards ? [{
        name: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.addToDashboardTitle', {
          defaultMessage: 'Add to dashboard'
        }),
        icon: 'dashboardApp',
        panel: 'attachToDashboardPanel',
        'data-test-subj': 'aiopsLogRateAnalysisAttachToDashboardButton'
      }] : []), ...(canUpdateCase || canCreateCase ? [{
        name: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.attachToCaseLabel', {
          defaultMessage: 'Add to case'
        }),
        icon: 'casesApp',
        'data-test-subj': 'aiopsLogRateAnalysisAttachToCaseButton',
        disabled: !isCasesAttachmentEnabled,
        ...(!isCasesAttachmentEnabled ? {
          toolTipProps: {
            position: 'left'
          },
          toolTipContent: caseAttachmentTooltipContent
        } : {}),
        onClick: () => {
          setIsActionMenuOpen(false);
          openCasesModalCallback({
            dataViewId: dataView.id,
            timeRange: absoluteTimeRange,
            ...(windowParameters && {
              windowParameters
            })
          });
        }
      }] : [])]
    }, {
      id: 'attachToDashboardPanel',
      size: 's',
      title: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.attachToDashboardTitle', {
        defaultMessage: 'Add to dashboard'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        paddingSize: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 175,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 176,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 177,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 178,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        label: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.applyTimeRangeLabel', {
          defaultMessage: 'Apply time range'
        }),
        checked: applyTimeRange,
        onChange: e => setApplyTimeRange(e.target.checked),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 179,
          columnNumber: 17
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 187,
          columnNumber: 15
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        size: "s",
        "data-test-subj": "aiopsLogRateAnalysisAttachToDashboardSubmitButton",
        fill: true,
        fullWidth: true,
        type: 'submit',
        onClick: () => {
          setIsActionMenuOpen(false);
          setDashboardAttachmentReady(true);
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 188,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.aiops.logRateAnalysis.attachToDashboardSubmitButtonLabel",
        defaultMessage: "Add to dashboard",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 199,
          columnNumber: 17
        }
      }))))
    }];
  }, [canEditDashboards, canUpdateCase, canCreateCase, isCasesAttachmentEnabled, caseAttachmentTooltipContent, applyTimeRange, openCasesModalCallback, dataView.id, absoluteTimeRange, windowParameters]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !!((_panels$ = panels[0]) !== null && _panels$ !== void 0 && (_panels$$items = _panels$.items) !== null && _panels$$items !== void 0 && _panels$$items.length) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "aiopsLogRateAnalysisAttachmentsMenuButton",
      "aria-label": _i18n.i18n.translate('xpack.aiops.logRateAnalysis.attachmentsMenuAriaLabel', {
        defaultMessage: 'Attachments'
      }),
      color: "text",
      display: "base",
      size: "s",
      isSelected: isActionMenuOpen,
      iconType: "boxesHorizontal",
      onClick: () => setIsActionMenuOpen(!isActionMenuOpen),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 15
      }
    }),
    isOpen: isActionMenuOpen,
    closePopover: () => setIsActionMenuOpen(false),
    panelPaddingSize: "none",
    anchorPosition: "downRight",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    panels: panels,
    initialPanelId: "attachMainPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 13
    }
  }))), dashboardAttachmentReady ? /*#__PURE__*/_react.default.createElement(SavedObjectSaveModalDashboard, {
    canSaveByReference: false,
    objectType: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.objectTypeLabel', {
      defaultMessage: 'Log rate analysis'
    }),
    documentInfo: {
      title: 'Log rate analysis'
    },
    onClose: () => setDashboardAttachmentReady(false),
    onSave: onSave,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 9
    }
  }) : null);
};
exports.LogRateAnalysisAttachmentsMenu = LogRateAnalysisAttachmentsMenu;