"use strict";

var _react = _interopRequireDefault(require("react"));
var _icon = require("./icon");
var _react2 = require("@emotion/react");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

describe('EuiIcons', function () {
  describe('Automated accessibility check for ML icons', function () {
    var MLIcons = ['dataVisualizer', 'createAdvancedJob', 'classificationJob', 'createMultiMetricJob', 'outlierDetectionJob', 'createPopulationJob', 'regressionJob', 'createSingleMetricJob'];
    var MLGrid = function MLGrid() {
      return (0, _react2.jsx)("div", null, MLIcons.map(function (glyph) {
        return (0, _react2.jsx)(_icon.EuiIcon, {
          className: "eui-alignMiddle",
          type: glyph
        });
      }));
    };
    it('has zero violations on first render', function () {
      cy.mount((0, _react2.jsx)(MLGrid, null));
      cy.get('div[data-cy-root]').find('svg', {
        timeout: 5000
      }).should('have.length', 8);
      cy.checkAxe();
    });
  });
});