"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isDashboardAppInNoDataState = exports.DashboardAppNoDataPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _esqlUtils = require("@kbn/esql-utils");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _visualizationUtils = require("@kbn/visualization-utils");
var _kibana_services = require("../../services/kibana_services");
var _dashboard_backup_service = require("../../services/dashboard_backup_service");
var _dashboard_content_management_service = require("../../services/dashboard_content_management_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard/public/dashboard_app/no_data/dashboard_app_no_data.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DashboardAppNoDataPage = ({
  onDataViewCreated
}) => {
  const analyticsServices = {
    coreStart: _kibana_services.coreServices,
    dataViews: _kibana_services.dataService.dataViews,
    dataViewEditor: _kibana_services.dataViewEditorService,
    noDataPage: _kibana_services.noDataPageService,
    share: _kibana_services.shareService
  };
  const [abortController, setAbortController] = (0, _react.useState)(new AbortController());
  const importPromise = Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/shared-ux-page-analytics-no-data')));
  const AnalyticsNoDataPageKibanaProvider = (0, _sharedUxUtility.withSuspense)(/*#__PURE__*/_react.default.lazy(() => importPromise.then(({
    AnalyticsNoDataPageKibanaProvider: NoDataProvider
  }) => {
    return {
      default: NoDataProvider
    };
  })));
  const lensHelpersAsync = (0, _useAsync.default)(() => {
    var _lensService$stateHel;
    return (_lensService$stateHel = _kibana_services.lensService === null || _kibana_services.lensService === void 0 ? void 0 : _kibana_services.lensService.stateHelperApi()) !== null && _lensService$stateHel !== void 0 ? _lensService$stateHel : Promise.resolve(null);
  }, [_kibana_services.lensService]);
  (0, _react.useEffect)(() => {
    return () => {
      abortController === null || abortController === void 0 ? void 0 : abortController.abort();
    };
  }, [abortController]);
  const onTryESQL = (0, _react.useCallback)(async () => {
    abortController === null || abortController === void 0 ? void 0 : abortController.abort();
    if (lensHelpersAsync.value) {
      var _await$getIndexForESQ;
      const abc = new AbortController();
      const {
        dataViews
      } = _kibana_services.dataService;
      const indexName = (_await$getIndexForESQ = await (0, _esqlUtils.getIndexForESQLQuery)({
        dataViews
      })) !== null && _await$getIndexForESQ !== void 0 ? _await$getIndexForESQ : '*';
      const dataView = await (0, _esqlUtils.getESQLAdHocDataview)(`from ${indexName}`, dataViews);
      const esqlQuery = (0, _esqlUtils.getInitialESQLQuery)(dataView);
      try {
        const columns = await (0, _esqlUtils.getESQLQueryColumns)({
          esqlQuery,
          search: _kibana_services.dataService.search.search,
          signal: abc.signal,
          timeRange: _kibana_services.dataService.query.timefilter.timefilter.getAbsoluteTime()
        });

        // lens suggestions api context
        const context = {
          dataViewSpec: dataView === null || dataView === void 0 ? void 0 : dataView.toSpec(false),
          fieldName: '',
          textBasedColumns: columns,
          query: {
            esql: esqlQuery
          }
        };
        setAbortController(abc);
        const chartSuggestions = lensHelpersAsync.value.suggestions(context, dataView);
        if (chartSuggestions !== null && chartSuggestions !== void 0 && chartSuggestions.length) {
          const [suggestion] = chartSuggestions;
          await _kibana_services.embeddableService.getStateTransfer().navigateToWithEmbeddablePackage('dashboards', {
            state: {
              type: 'lens',
              serializedState: {
                rawState: {
                  attributes: (0, _visualizationUtils.getLensAttributesFromSuggestion)({
                    filters: [],
                    query: {
                      esql: esqlQuery
                    },
                    suggestion,
                    dataView
                  })
                }
              }
            },
            path: '#/create'
          });
        }
      } catch (error) {
        if (error.name !== 'AbortError') {
          _kibana_services.coreServices.notifications.toasts.addWarning(_i18n.i18n.translate('dashboard.noDataviews.esqlRequestWarningMessage', {
            defaultMessage: 'Unable to load columns. {errorMessage}',
            values: {
              errorMessage: error.message
            }
          }));
        }
      }
    }
  }, [abortController, lensHelpersAsync.value]);
  const AnalyticsNoDataPage = (0, _sharedUxUtility.withSuspense)(/*#__PURE__*/_react.default.lazy(() => importPromise.then(({
    AnalyticsNoDataPage: NoDataPage
  }) => {
    return {
      default: NoDataPage
    };
  })));
  return /*#__PURE__*/_react.default.createElement(AnalyticsNoDataPageKibanaProvider, (0, _extends2.default)({}, analyticsServices, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(AnalyticsNoDataPage, {
    onDataViewCreated: onDataViewCreated,
    onTryESQL: onTryESQL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  }));
};
exports.DashboardAppNoDataPage = DashboardAppNoDataPage;
const isDashboardAppInNoDataState = async () => {
  const hasUserDataView = await _kibana_services.dataService.dataViews.hasData.hasUserDataView().catch(() => false);
  if (hasUserDataView) return false;

  // consider has data if there is unsaved dashboard with edits
  if ((0, _dashboard_backup_service.getDashboardBackupService)().dashboardHasUnsavedEdits()) return false;

  // consider has data if there is at least one dashboard
  const {
    total
  } = await (0, _dashboard_content_management_service.getDashboardContentManagementService)().findDashboards.search({
    search: '',
    size: 1
  }).catch(() => ({
    total: 0
  }));
  if (total > 0) return false;
  return true;
};
exports.isDashboardAppInNoDataState = isDashboardAppInNoDataState;