"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNestedMenu = exports.NestedMenuContext = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const NestedMenuContext = exports.NestedMenuContext = /*#__PURE__*/(0, _react.createContext)(null);
const useNestedMenu = () => {
  const context = (0, _react.useContext)(NestedMenuContext);
  if (!context) {
    throw new Error('useNestedMenu must be used within a NestedSecondaryMenu');
  }
  return context;
};
exports.useNestedMenu = useNestedMenu;