"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Styles = void 0;
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/rendering/server-internal/src/views/styles.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const Styles = ({
  darkMode,
  themeName,
  stylesheetPaths
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, darkMode !== 'system' && /*#__PURE__*/_react.default.createElement(InlineStyles, {
    darkMode: darkMode,
    themeName: themeName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 33
    }
  }), stylesheetPaths.map(path => /*#__PURE__*/_react.default.createElement("link", {
    key: path,
    rel: "stylesheet",
    type: "text/css",
    href: path,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 9
    }
  })));
};
exports.Styles = Styles;
const InlineStyles = ({
  darkMode,
  themeName
}) => {
  const getThemeStyles = theme => {
    if (theme === 'borealis') {
      return {
        pageBackground: darkMode ? '#07101F' : '#F6F9FC',
        // colors.body
        welcomeText: darkMode ? '#8E9FBC' : '#5A6D8C',
        // colors.subduedText
        progress: darkMode ? '#172336' : '#ECF1F9',
        // colors.lightestShade
        progressBefore: darkMode ? '#599DFF' : '#0B64DD' // colors.primary
      };
    }
    return {
      pageBackground: darkMode ? '#141519' : '#F8FAFD',
      welcomeText: darkMode ? '#98A2B3' : '#69707D',
      progress: darkMode ? '#25262E' : '#F5F7FA',
      progressBefore: darkMode ? '#1BA9F5' : '#006DE4'
    };
  };
  const themeStyles = getThemeStyles(themeName);

  /* eslint-disable react/no-danger */
  return /*#__PURE__*/_react.default.createElement("style", {
    dangerouslySetInnerHTML: {
      __html: `

          html {
            background-color: ${themeStyles.pageBackground}
          }

          .kbnWelcomeText {
            color: ${themeStyles.welcomeText};
          }

          .kbnProgress {
            background-color: ${themeStyles.progress};
          }

          .kbnProgress:before {
            background-color: ${themeStyles.progressBefore};
          }

        `
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  });
  /* eslint-enable react/no-danger */
};