"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isKibanaResponse = isKibanaResponse;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * HTTP response parameters
 * @public
 */

/**
 * Data send to the client as a response payload.
 * @public
 */

/**
 * Additional data to provide error details.
 * @public
 */

/**
 * Error message and optional data send to the client in case of error.
 * @public
 */

/**
 * A response data object, expected to returned as a result of {@link RequestHandler} execution
 * @public
 */

function isKibanaResponse(response) {
  if (!response) {
    return false;
  }
  const {
    status,
    options,
    payload,
    ...rest
  } = response;
  if (Object.keys(rest).length !== 0) {
    return false;
  }
  return typeof status === 'number' && typeof options === 'object' && !Array.isArray(options) && options !== null && !(options instanceof Set);
}

/**
 * HTTP response parameters for a response with adjustable status code.
 * @public
 */

/**
 * HTTP response parameters for a response with adjustable status code.
 * @public
 */

/**
 * HTTP response parameters for redirection response
 * @public
 */

/**
 * HTTP response parameters
 * @public
 */