"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getESQLControlFactory = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _esqlTypes = require("@kbn/esql-types");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _presentationContainers = require("@kbn/presentation-containers");
var _controlsConstants = require("@kbn/controls-constants");
var _kibana_services = require("../../services/kibana_services");
var _default_control_manager = require("../default_control_manager");
var _esql_control_selections = require("./esql_control_selections");
var _options_list_context_provider = require("../data_controls/options_list_control/options_list_context_provider");
var _options_list_control = require("../data_controls/options_list_control/components/options_list_control");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/controls/public/controls/esql_control/get_esql_control_factory.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const displayName = _i18n.i18n.translate('controls.esqlValuesControl.displayName', {
  defaultMessage: 'Static values list'
});
const getESQLControlFactory = () => {
  return {
    type: _controlsConstants.ESQL_CONTROL,
    order: 3,
    getIconType: () => 'editorChecklist',
    getDisplayName: () => displayName,
    buildControl: async ({
      initialState,
      finalizeApi,
      uuid,
      controlGroupApi
    }) => {
      const defaultControlManager = (0, _default_control_manager.initializeDefaultControlManager)(initialState);
      const selections = (0, _esql_control_selections.initializeESQLControlSelections)(initialState, controlGroupApi.controlFetch$(uuid), defaultControlManager.api.setDataLoading);
      const onSaveControl = updatedState => {
        controlGroupApi === null || controlGroupApi === void 0 ? void 0 : controlGroupApi.replacePanel(uuid, {
          panelType: 'esqlControl',
          serializedState: {
            rawState: updatedState
          }
        });
      };
      function serializeState() {
        return {
          rawState: {
            ...defaultControlManager.getLatestState(),
            ...selections.getLatestState()
          },
          references: []
        };
      }
      const unsavedChangesApi = (0, _presentationContainers.initializeUnsavedChanges)({
        uuid,
        parentApi: controlGroupApi,
        serializeState,
        anyStateChange$: (0, _rxjs.merge)(defaultControlManager.anyStateChange$, selections.anyStateChange$),
        getComparators: () => {
          return {
            ..._default_control_manager.defaultControlComparators,
            ..._esql_control_selections.selectionComparators
          };
        },
        onReset: lastSaved => {
          defaultControlManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
          selections.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
        }
      });
      const api = finalizeApi({
        ...unsavedChangesApi,
        ...defaultControlManager.api,
        ...selections.api,
        defaultTitle$: new _rxjs.BehaviorSubject(initialState.title),
        isEditingEnabled: () => true,
        getTypeDisplayName: () => displayName,
        onEdit: async () => {
          const state = {
            ...initialState,
            ...defaultControlManager.getLatestState()
          };
          const variablesInParent = (0, _esqlTypes.apiPublishesESQLVariables)(api.parentApi) ? api.parentApi.esqlVariables$.value : [];
          try {
            await _kibana_services.uiActionsService.getTrigger('ESQL_CONTROL_TRIGGER').exec({
              queryString: initialState.esqlQuery,
              variableType: initialState.variableType,
              controlType: initialState.controlType,
              esqlVariables: variablesInParent,
              onSaveControl,
              initialState: state
            });
          } catch (e) {
            // eslint-disable-next-line no-console
            console.error('Error getting ESQL control trigger', e);
          }
        },
        serializeState
      });
      const componentStaticState = {
        singleSelect: true,
        exclude: false,
        existsSelected: false,
        requestSize: 0,
        dataLoading: false,
        sort: undefined,
        runPastTimeout: false,
        invalidSelections: new Set(),
        fieldName: initialState.variableName
      };
      // Generate a state manager for all the props this control isn't expected to use, so the getters and setters are available
      const componentStaticStateManager = (0, _presentationPublishing.initializeStateManager)(componentStaticState, componentStaticState);
      const componentApi = {
        ...api,
        ...selections.internalApi,
        uuid,
        makeSelection(key) {
          if (key) selections.internalApi.setSelectedOptions([key]);
        },
        // Pass no-ops and default values for all of the features of OptionsList that ES|QL controls don't currently use
        ...componentStaticStateManager.api,
        deselectOption: () => {},
        selectAll: () => {},
        deselectAll: () => {},
        loadMoreSubject: new _rxjs.BehaviorSubject(undefined),
        fieldFormatter: new _rxjs.BehaviorSubject(v => v)
      };
      return {
        api,
        Component: ({
          className: controlPanelClassName
        }) => /*#__PURE__*/_react.default.createElement(_options_list_context_provider.OptionsListControlContext.Provider, {
          value: {
            componentApi,
            displaySettings: {
              hideActionBar: false,
              hideExclude: true,
              hideExists: true,
              hideSort: true
            }
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 153,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_options_list_control.OptionsListControl, {
          controlPanelClassName: controlPanelClassName,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 164,
            columnNumber: 13
          }
        }))
      };
    }
  };
};
exports.getESQLControlFactory = getESQLControlFactory;