"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSecuritySolutionLink = void 0;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Gets the cloud security posture link properties of a CSP page for navigation in the security solution.
 * @param cloudSecurityPosturePage the name of the cloud posture page.
 */
const getSecuritySolutionLink = cloudSecurityPosturePage => ({
  id: _constants.cloudPosturePages[cloudSecurityPosturePage].id,
  title: _constants.cloudPosturePages[cloudSecurityPosturePage].name,
  path: _constants.cloudPosturePages[cloudSecurityPosturePage].path
});
exports.getSecuritySolutionLink = getSecuritySolutionLink;