"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withDebounceArg = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _reactFastCompare = _interopRequireDefault(require("react-fast-compare"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/with_debounce_arg/with_debounce_arg.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const withDebounceArg = (Arg, debouncePeriod = 150) => ({
  argValue,
  onValueChange,
  ...restProps
}) => {
  const [localArgValue, setArgValue] = (0, _react.useState)(argValue);
  const [, cancel] = (0, _useDebounce.default)(() => {
    if (localArgValue === argValue || (0, _reactFastCompare.default)(localArgValue, argValue)) {
      return;
    }
    onValueChange(localArgValue);
  }, debouncePeriod, [localArgValue]);

  // handle the changed argument from within the expression.
  (0, _react.useEffect)(() => {
    if (argValue) {
      setArgValue(argValue);
    }
  }, [argValue]);
  (0, _react.useEffect)(() => {
    return () => {
      cancel();
    };
  }, [cancel]);
  return /*#__PURE__*/_react.default.createElement(Arg, (0, _extends2.default)({}, restProps, {
    argValue: localArgValue,
    onValueChange: setArgValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 12
    }
  }));
};
exports.withDebounceArg = withDebounceArg;