"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditVar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _var_value_field = require("./var_value_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/var_config/edit_var.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getAddTitle: () => _i18n.i18n.translate('xpack.canvas.varConfigEditVar.addTitleLabel', {
    defaultMessage: 'Add variable'
  }),
  getCancelButtonLabel: () => _i18n.i18n.translate('xpack.canvas.varConfigEditVar.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  }),
  getDuplicateNameError: () => _i18n.i18n.translate('xpack.canvas.varConfigEditVar.duplicateNameError', {
    defaultMessage: 'Variable name already in use'
  }),
  getEditTitle: () => _i18n.i18n.translate('xpack.canvas.varConfigEditVar.editTitleLabel', {
    defaultMessage: 'Edit variable'
  }),
  getEditWarning: () => _i18n.i18n.translate('xpack.canvas.varConfigEditVar.editWarning', {
    defaultMessage: 'Editing a variable in use may adversely affect your workpad'
  }),
  getNameFieldLabel: () => _i18n.i18n.translate('xpack.canvas.varConfigEditVar.nameFieldLabel', {
    defaultMessage: 'Name'
  }),
  getSaveButtonLabel: () => _i18n.i18n.translate('xpack.canvas.varConfigEditVar.saveButtonLabel', {
    defaultMessage: 'Save changes'
  }),
  getTypeBooleanLabel: () => _i18n.i18n.translate('xpack.canvas.varConfigEditVar.typeBooleanLabel', {
    defaultMessage: 'Boolean'
  }),
  getTypeFieldLabel: () => _i18n.i18n.translate('xpack.canvas.varConfigEditVar.typeFieldLabel', {
    defaultMessage: 'Type'
  }),
  getTypeNumberLabel: () => _i18n.i18n.translate('xpack.canvas.varConfigEditVar.typeNumberLabel', {
    defaultMessage: 'Number'
  }),
  getTypeStringLabel: () => _i18n.i18n.translate('xpack.canvas.varConfigEditVar.typeStringLabel', {
    defaultMessage: 'String'
  }),
  getValueFieldLabel: () => _i18n.i18n.translate('xpack.canvas.varConfigEditVar.valueFieldLabel', {
    defaultMessage: 'Value'
  })
};
const checkDupeName = (newName, oldName, variables) => {
  const match = variables.find(v => {
    // If the new name matches an existing variable and that
    // matched variable name isn't the old name, then there
    // is a duplicate
    return newName === v.name && (!oldName || v.name !== oldName);
  });
  return !!match;
};
const EditVar = ({
  variables,
  selectedVar,
  onCancel,
  onSave
}) => {
  // If there isn't a selected variable, we're creating a new var
  const isNew = selectedVar === null;
  const [type, setType] = (0, _react.useState)(isNew ? 'string' : selectedVar.type);
  const [name, setName] = (0, _react.useState)(isNew ? '' : selectedVar.name);
  const [value, setValue] = (0, _react.useState)(isNew ? '' : selectedVar.value);
  const hasDupeName = checkDupeName(name, selectedVar && selectedVar.name, variables);
  const hasEmptyValue = value.toString().trim() === '';
  const hasEmptyName = !name;
  const typeOptions = [{
    value: 'string',
    inputDisplay: /*#__PURE__*/_react.default.createElement("div", {
      className: "canvasEditVar__typeOption",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToken, {
      iconType: "tokenString",
      className: "canvasEditVar__tokenIcon",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 11
      }
    }), ' ', /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 11
      }
    }, strings.getTypeStringLabel()))
  }, {
    value: 'number',
    inputDisplay: /*#__PURE__*/_react.default.createElement("div", {
      className: "canvasEditVar__typeOption",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToken, {
      iconType: "tokenNumber",
      className: "canvasEditVar__tokenIcon",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 11
      }
    }), ' ', /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 11
      }
    }, strings.getTypeNumberLabel()))
  }, {
    value: 'boolean',
    inputDisplay: /*#__PURE__*/_react.default.createElement("div", {
      className: "canvasEditVar__typeOption",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToken, {
      iconType: "tokenBoolean",
      className: "canvasEditVar__tokenIcon",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 11
      }
    }), ' ', /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 11
      }
    }, strings.getTypeBooleanLabel()))
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasVarHeader__triggerWrapper",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("button", {
    className: "canvasVarHeader__button",
    type: "button",
    onClick: () => onCancel(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "canvasVarHeader__iconWrapper",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "sortLeft",
    style: {
      verticalAlign: 'top'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "canvasVarHeader__anchor",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 13
    }
  }, isNew ? strings.getAddTitle() : strings.getEditTitle())))), /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasSidebar__accordionContent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 7
    }
  }, !isNew && /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: strings.getEditWarning(),
    color: "warning",
    iconType: "warning",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getTypeFieldLabel(),
    display: "rowCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    options: typeOptions,
    valueOfSelected: type,
    onChange: v => {
      // Only have these types possible in the dropdown
      setType(v);

      // Reset default value
      if (v === 'boolean') {
        // Just setting a default value
        setValue(true);
      } else if (v === 'number') {
        // Setting default number
        setValue(0);
      } else {
        setValue('');
      }
    },
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getNameFieldLabel(),
    display: "rowCompressed",
    isInvalid: hasDupeName,
    error: hasDupeName && strings.getDuplicateNameError(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "name",
    value: name,
    compressed: true,
    onChange: e => setName(e.target.value),
    isInvalid: hasDupeName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getValueFieldLabel(),
    display: "rowCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_var_value_field.VarValueField, {
    type: type,
    value: value,
    onChange: v => setValue(v),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    fill: true,
    onClick: () => onSave({
      name,
      value,
      type
    }),
    disabled: hasDupeName || hasEmptyValue || hasEmptyName,
    iconType: "save",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 15
    }
  }, strings.getSaveButtonLabel())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    onClick: () => onCancel(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 15
    }
  }, strings.getCancelButtonLabel()))))));
};
exports.EditVar = EditVar;