"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.callSourcesAPI = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const callSourcesAPI = (http, pathname, options) => {
  const [method, path] = pathname.split(' ');
  return http[method.toLowerCase()](path, {
    body: (options === null || options === void 0 ? void 0 : options.body) != null ? JSON.stringify(options.body) : undefined,
    signal: options === null || options === void 0 ? void 0 : options.signal
  });
};
exports.callSourcesAPI = callSourcesAPI;