"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APMAlertingThroughputChart = APMAlertingThroughputChart;
var _react = _interopRequireDefault(require("react"));
var _environment_filter_values = require("../../../../common/environment_filter_values");
var _throughput_chart = _interopRequireDefault(require("../../../components/alerting/ui_components/alert_details_app_section/throughput_chart"));
var _use_alerting_props = require("../use_alerting_props");
var _time_range_callout = require("../time_range_callout");
var _service_name_callout = require("../service_name_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/embeddable/alerting/alerting_throughput_chart/chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function APMAlertingThroughputChart({
  rule,
  rangeFrom = 'now-15m',
  rangeTo = 'now',
  transactionName,
  kuery,
  filters,
  serviceName,
  transactionType,
  environment = _environment_filter_values.ENVIRONMENT_ALL.value
}) {
  const {
    comparisonChartTheme,
    setTransactionType,
    transactionType: currentTransactionType,
    transactionTypes,
    timeZone
  } = (0, _use_alerting_props.useAlertingProps)({
    rule,
    rangeTo,
    rangeFrom,
    defaultTransactionType: transactionType,
    serviceName
  });
  if (!rangeFrom || !rangeTo) {
    return /*#__PURE__*/_react.default.createElement(_time_range_callout.TimeRangeCallout, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 12
      }
    });
  }
  if (!serviceName || !currentTransactionType) {
    return /*#__PURE__*/_react.default.createElement(_service_name_callout.ServiceNameCallout, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_throughput_chart.default, {
    transactionType: currentTransactionType,
    transactionTypes: transactionTypes,
    setTransactionType: setTransactionType,
    transactionName: transactionName,
    serviceName: serviceName,
    environment: environment,
    start: rangeFrom,
    end: rangeTo,
    comparisonChartTheme: comparisonChartTheme,
    timeZone: timeZone,
    comparisonEnabled: false,
    offset: '',
    kuery: kuery,
    filters: filters,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  });
}