"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Sort = Sort;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_groups/service_groups_list/sort.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const options = [{
  value: 'recently_added',
  text: _i18n.i18n.translate('xpack.apm.serviceGroups.list.sort.recentlyAdded', {
    defaultMessage: 'Recently added'
  })
}, {
  value: 'alphabetical',
  text: _i18n.i18n.translate('xpack.apm.serviceGroups.list.sort.alphabetical', {
    defaultMessage: 'Alphabetical'
  })
}];
function Sort({
  type,
  onChange
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "apmSortSelect",
    "aria-label": _i18n.i18n.translate('xpack.apm.serviceGroups.list.sort.ariaLabel', {
      defaultMessage: 'Sort service groups by'
    }),
    compressed: true,
    options: options,
    value: type,
    onChange: e => onChange(e.target.value),
    prepend: _i18n.i18n.translate('xpack.apm.serviceGroups.sortLabel', {
      defaultMessage: 'Sort'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  });
}