"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformBulkGetResultToResponse = void 0;
var _transforms = require("../../../transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformBulkGetResultToResponse = result => {
  return {
    maintenance_windows: result.maintenanceWindows.map(mw => {
      return (0, _transforms.transformInternalMaintenanceWindowToExternalV1)(mw);
    }),
    errors: result.errors.map(error => {
      return {
        id: error.id,
        error: error.error,
        message: error.message,
        status_code: error.statusCode
      };
    })
  };
};
exports.transformBulkGetResultToResponse = transformBulkGetResultToResponse;