"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateMaintenanceWindow = useCreateMaintenanceWindow;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@kbn/react-query");
var _kibana_react = require("../utils/kibana_react");
var _create = require("../services/maintenance_windows_api/create");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const onErrorWithMessage = message => _i18n.i18n.translate('xpack.alerting.maintenanceWindowsCreateFailureWithMessage', {
  defaultMessage: 'Failed to create maintenance window: {message}',
  values: {
    message
  }
});
const onErrorWithoutMessage = _i18n.i18n.translate('xpack.alerting.maintenanceWindowsCreateFailureWithoutMessage', {
  defaultMessage: 'Failed to create maintenance window'
});
function useCreateMaintenanceWindow(props) {
  const {
    onError
  } = props || {};
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana_react.useKibana)().services;
  const mutationFn = createParams => {
    return (0, _create.createMaintenanceWindow)({
      http,
      createParams
    });
  };
  return (0, _reactQuery.useMutation)(mutationFn, {
    onSuccess: data => {
      toasts.addSuccess(_i18n.i18n.translate('xpack.alerting.maintenanceWindowsCreateSuccess', {
        defaultMessage: "Created maintenance window ''{title}''",
        values: {
          title: data.title
        }
      }));
    },
    onError: error => {
      var _error$body, _error$body2;
      const getDefaultErrorMessage = message => !message ? onErrorWithoutMessage : onErrorWithMessage(message);
      toasts.addDanger(getDefaultErrorMessage(((_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.statusCode) === 400 ? (_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : _error$body2.message : ''));
      onError === null || onError === void 0 ? void 0 : onError(error);
    }
  });
}