"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSystemDefaultsProvider = void 0;
var _react = _interopRequireDefault(require("react"));
var _services = require("../../../services");
var _match_media_hook = require("./match_media_hook");
var _react2 = require("@emotion/react");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var EuiSystemDefaultsProvider = exports.EuiSystemDefaultsProvider = function EuiSystemDefaultsProvider(_ref) {
  var children = _ref.children;
  // @see https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-color-scheme
  var systemColorMode = (0, _match_media_hook.useWindowMediaMatcher)('(prefers-color-scheme: dark)') ? 'DARK' : 'LIGHT';

  //  There are different types of high contrast modes based on system/OS settings. @see:
  // - https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-contrast
  // - https://developer.mozilla.org/en-US/docs/Web/CSS/@media/forced-colors
  // - https://kilianvalkhof.com/2023/css-html/i-no-longer-understand-prefers-contrast/
  var windowsHighContrast = (0, _match_media_hook.useWindowMediaMatcher)('(forced-colors: active)');
  var macHighContrast = (0, _match_media_hook.useWindowMediaMatcher)('(prefers-contrast: more)');
  var systemHighContrastMode = windowsHighContrast ? 'forced' : macHighContrast ? 'preferred' : false;
  return (0, _react2.jsx)(_services.EuiColorModeContext.Provider, {
    value: systemColorMode
  }, (0, _react2.jsx)(_services.EuiHighContrastModeContext.Provider, {
    value: systemHighContrastMode
  }, children));
};