/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.section;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.client.NodeSelector;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.Channels;
import org.elasticsearch.test.rest.yaml.ParameterizableYamlXContentParser;
import org.elasticsearch.test.rest.yaml.section.ClientYamlTestSection;
import org.elasticsearch.test.rest.yaml.section.CloseToAssertion;
import org.elasticsearch.test.rest.yaml.section.ContainsAssertion;
import org.elasticsearch.test.rest.yaml.section.DoSection;
import org.elasticsearch.test.rest.yaml.section.ExecutableSection;
import org.elasticsearch.test.rest.yaml.section.IsAfterAssertion;
import org.elasticsearch.test.rest.yaml.section.PrerequisiteSection;
import org.elasticsearch.test.rest.yaml.section.SetupSection;
import org.elasticsearch.test.rest.yaml.section.TeardownSection;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.yaml.YamlXContent;

public class ClientYamlTestSuite {
    private final String api;
    private final String name;
    private final Optional<Path> file;
    private final SetupSection setupSection;
    private final TeardownSection teardownSection;
    private final List<ClientYamlTestSection> testSections;

    public static ClientYamlTestSuite parse(NamedXContentRegistry executeableSectionRegistry, String api, Path file, Map<String, ?> params) throws IOException {
        ClientYamlTestSuite clientYamlTestSuite;
        block19: {
            if (!Files.isRegularFile(file, new LinkOption[0])) {
                throw new IllegalArgumentException(String.valueOf(file.toAbsolutePath()) + " is not a file");
            }
            String filename = file.getFileName().toString();
            int i = filename.lastIndexOf(46);
            if (i > 0) {
                filename = filename.substring(0, i);
            }
            try (FileChannel channel = FileChannel.open(file, StandardOpenOption.READ);){
                ByteBuffer bb = ByteBuffer.wrap(new byte[1]);
                if (channel.size() == 0L) {
                    throw new IllegalArgumentException("test suite file " + file.toString() + " is empty");
                }
                Channels.readFromFileChannel((FileChannel)channel, (long)(channel.size() - 1L), (ByteBuffer)bb);
                if (bb.get(0) != 10) {
                    throw new IOException("test suite [" + api + "/" + filename + "] doesn't end with line feed (\\n)");
                }
            }
            ParameterizableYamlXContentParser parser = params.isEmpty() ? YamlXContent.yamlXContent.createParser(XContentParserConfiguration.EMPTY.withRegistry(executeableSectionRegistry), Files.newInputStream(file, new OpenOption[0])) : new ParameterizableYamlXContentParser(YamlXContent.yamlXContent.createParser(XContentParserConfiguration.EMPTY.withRegistry(executeableSectionRegistry), Files.newInputStream(file, new OpenOption[0])), params);
            try {
                clientYamlTestSuite = ClientYamlTestSuite.parse(api, filename, Optional.of(file), parser);
                if (parser == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException("Error parsing " + api + "/" + filename, e);
                }
            }
            parser.close();
        }
        return clientYamlTestSuite;
    }

    public static ClientYamlTestSuite parse(String api, String suiteName, Optional<Path> file, XContentParser parser) throws IOException {
        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new XContentParseException(parser.getTokenLocation(), "expected token to be START_OBJECT but was " + String.valueOf(parser.currentToken()));
        }
        SetupSection setupSection = SetupSection.parseIfNext(parser);
        TeardownSection teardownSection = TeardownSection.parseIfNext(parser);
        TreeSet<ClientYamlTestSection> testSections = new TreeSet<ClientYamlTestSection>();
        while (parser.currentToken() != null || parser.nextToken() != null) {
            ClientYamlTestSection testSection = ClientYamlTestSection.parse(parser);
            if (testSections.add(testSection)) continue;
            throw new ParsingException(testSection.getLocation(), "duplicate test section [" + testSection.getName() + "]", new Object[0]);
        }
        return new ClientYamlTestSuite(api, suiteName, file, setupSection, teardownSection, new ArrayList<ClientYamlTestSection>(testSections));
    }

    public static ClientYamlTestSuite parse(NamedXContentRegistry xcontentRegistry, String api, Path filePath) throws IOException {
        return ClientYamlTestSuite.parse(xcontentRegistry, api, filePath, Collections.emptyMap());
    }

    public ClientYamlTestSuite(String api, String name, Optional<Path> file, SetupSection setupSection, TeardownSection teardownSection, List<ClientYamlTestSection> testSections) {
        this.api = api.replace("\\", "/");
        this.name = name;
        this.file = file;
        this.setupSection = Objects.requireNonNull(setupSection, "setup section cannot be null");
        this.teardownSection = Objects.requireNonNull(teardownSection, "teardown section cannot be null");
        this.testSections = Collections.unmodifiableList(testSections);
    }

    public String getApi() {
        return this.api;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.api + "/" + this.name;
    }

    public Optional<Path> getFile() {
        return this.file;
    }

    public SetupSection getSetupSection() {
        return this.setupSection;
    }

    public TeardownSection getTeardownSection() {
        return this.teardownSection;
    }

    public void validate() {
        Stream<String> errors = ClientYamlTestSuite.validateExecutableSections(this.setupSection.getExecutableSections(), null, this.setupSection, null);
        errors = Stream.concat(errors, ClientYamlTestSuite.validateExecutableSections(this.teardownSection.getDoSections(), null, null, this.teardownSection));
        String errorMessage = (errors = Stream.concat(errors, this.testSections.stream().flatMap(section -> ClientYamlTestSuite.validateExecutableSections(section.getExecutableSections(), section, this.setupSection, this.teardownSection)))).collect(Collectors.joining(",\n"));
        if (!errorMessage.isEmpty()) {
            throw new IllegalArgumentException(this.getPath() + ":\n" + errorMessage);
        }
    }

    private static Stream<String> validateExecutableSections(List<ExecutableSection> sections, ClientYamlTestSection testSection, SetupSection setupSection, TeardownSection teardownSection) {
        Stream<String> errors = sections.stream().filter(section -> section instanceof DoSection).map(section -> (DoSection)section).filter(section -> false == section.getExpectedWarningHeaders().isEmpty()).filter(section -> false == ClientYamlTestSuite.hasYamlRunnerFeature("warnings", testSection, setupSection, teardownSection)).map(section -> String.format(Locale.ROOT, "attempted to add a [do] with a [warnings] section without a corresponding [\"requires\": \"test_runner_features\": \"warnings\"] so runners that do not support the [warnings] section can skip the test at line [%d]", section.getLocation().lineNumber()));
        errors = Stream.concat(errors, sections.stream().filter(section -> section instanceof DoSection).map(section -> (DoSection)section).filter(section -> false == section.getExpectedWarningHeadersRegex().isEmpty()).filter(section -> false == ClientYamlTestSuite.hasYamlRunnerFeature("warnings_regex", testSection, setupSection, teardownSection)).map(section -> String.format(Locale.ROOT, "attempted to add a [do] with a [warnings_regex] section without a corresponding [\"requires\": \"test_runner_features\": \"warnings_regex\"] so runners that do not support the [warnings_regex] section can skip the test at line [%d]", section.getLocation().lineNumber())));
        errors = Stream.concat(errors, sections.stream().filter(section -> section instanceof DoSection).map(section -> (DoSection)section).filter(section -> false == section.getAllowedWarningHeaders().isEmpty()).filter(section -> false == ClientYamlTestSuite.hasYamlRunnerFeature("allowed_warnings", testSection, setupSection, teardownSection)).map(section -> String.format(Locale.ROOT, "attempted to add a [do] with a [allowed_warnings] section without a corresponding [\"requires\": \"test_runner_features\": \"allowed_warnings\"] so runners that do not support the [allowed_warnings] section can skip the test at line [%d]", section.getLocation().lineNumber())));
        errors = Stream.concat(errors, sections.stream().filter(section -> section instanceof DoSection).map(section -> (DoSection)section).filter(section -> false == section.getAllowedWarningHeadersRegex().isEmpty()).filter(section -> false == ClientYamlTestSuite.hasYamlRunnerFeature("allowed_warnings_regex", testSection, setupSection, teardownSection)).map(section -> String.format(Locale.ROOT, "attempted to add a [do] with a [allowed_warnings_regex] section without a corresponding [\"requires\": \"test_runner_features\": \"allowed_warnings_regex\"] so runners that do not support the [allowed_warnings_regex] section can skip the test at line [%d]", section.getLocation().lineNumber())));
        errors = Stream.concat(errors, sections.stream().filter(section -> section instanceof DoSection).map(section -> (DoSection)section).filter(section -> NodeSelector.ANY != section.getApiCallSection().getNodeSelector()).filter(section -> false == ClientYamlTestSuite.hasYamlRunnerFeature("node_selector", testSection, setupSection, teardownSection)).map(section -> String.format(Locale.ROOT, "attempted to add a [do] with a [node_selector] section without a corresponding [\"requires\": \"test_runner_features\": \"node_selector\"] so runners that do not support the [node_selector] section can skip the test at line [%d]", section.getLocation().lineNumber())));
        errors = Stream.concat(errors, sections.stream().filter(section -> section instanceof ContainsAssertion).filter(section -> false == ClientYamlTestSuite.hasYamlRunnerFeature("contains", testSection, setupSection, teardownSection)).map(section -> String.format(Locale.ROOT, "attempted to add a [contains] assertion without a corresponding [\"requires\": \"test_runner_features\": \"contains\"] so runners that do not support the [contains] assertion can skip the test at line [%d]", section.getLocation().lineNumber())));
        errors = Stream.concat(errors, sections.stream().filter(section -> section instanceof DoSection).map(section -> (DoSection)section).filter(section -> false == section.getApiCallSection().getHeaders().isEmpty()).filter(section -> false == ClientYamlTestSuite.hasYamlRunnerFeature("headers", testSection, setupSection, teardownSection)).map(section -> String.format(Locale.ROOT, "attempted to add a [do] with a [headers] section without a corresponding [\"requires\": \"test_runner_features\": \"headers\"] so runners that do not support the [headers] section can skip the test at line [%d]", section.getLocation().lineNumber())));
        errors = Stream.concat(errors, sections.stream().filter(section -> section instanceof CloseToAssertion).filter(section -> false == ClientYamlTestSuite.hasYamlRunnerFeature("close_to", testSection, setupSection, teardownSection)).map(section -> String.format(Locale.ROOT, "attempted to add a [close_to] assertion without a corresponding [\"requires\": \"test_runner_features\": \"close_to\"] so runners that do not support the [close_to] assertion can skip the test at line [%d]", section.getLocation().lineNumber())));
        errors = Stream.concat(errors, sections.stream().filter(section -> section instanceof IsAfterAssertion).filter(section -> false == ClientYamlTestSuite.hasYamlRunnerFeature("is_after", testSection, setupSection, teardownSection)).map(section -> String.format(Locale.ROOT, "attempted to add an [is_after] assertion without a corresponding [\"requires\": \"test_runner_features\": \"is_after\"] so runners that do not support the [is_after] assertion can skip the test at line [%d]", section.getLocation().lineNumber())));
        if (ClientYamlTestSuite.hasCapabilitiesCheck(testSection, setupSection, teardownSection) && !ClientYamlTestSuite.hasYamlRunnerFeature("capabilities", testSection, setupSection, teardownSection)) {
            errors = Stream.concat(errors, Stream.of("attempted to add a [capabilities] check in prerequisites without a corresponding [\"requires\": \"test_runner_features\": \"capabilities\"] so runners that do not support [capabilities] checks can skip the test"));
        }
        return errors;
    }

    private static boolean hasYamlRunnerFeature(String feature, ClientYamlTestSection testSection, SetupSection setupSection, TeardownSection teardownSection) {
        return testSection != null && ClientYamlTestSuite.hasYamlRunnerFeature(feature, testSection.getPrerequisiteSection()) || setupSection != null && ClientYamlTestSuite.hasYamlRunnerFeature(feature, setupSection.getPrerequisiteSection()) || teardownSection != null && ClientYamlTestSuite.hasYamlRunnerFeature(feature, teardownSection.getPrerequisiteSection());
    }

    private static boolean hasCapabilitiesCheck(ClientYamlTestSection testSection, SetupSection setupSection, TeardownSection teardownSection) {
        return testSection != null && testSection.getPrerequisiteSection().hasCapabilitiesCheck() || setupSection != null && setupSection.getPrerequisiteSection().hasCapabilitiesCheck() || teardownSection != null && teardownSection.getPrerequisiteSection().hasCapabilitiesCheck();
    }

    private static boolean hasYamlRunnerFeature(String feature, PrerequisiteSection prerequisiteSection) {
        return prerequisiteSection != null && prerequisiteSection.hasYamlRunnerFeature(feature);
    }

    public List<ClientYamlTestSection> getTestSections() {
        return this.testSections;
    }
}

