/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.lucene.search.CollectorManager;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorCollector;
import org.elasticsearch.search.aggregations.InternalAggregations;

public class AggregatorCollectorManager
implements CollectorManager<AggregatorCollector, Void> {
    private final Supplier<AggregatorCollector> collectorSupplier;
    private final Consumer<InternalAggregations> internalAggregationsConsumer;
    private final Supplier<AggregationReduceContext> reduceContextSupplier;

    public AggregatorCollectorManager(Supplier<AggregatorCollector> collectorSupplier, Consumer<InternalAggregations> internalAggregationsConsumer, Supplier<AggregationReduceContext> reduceContextSupplier) {
        this.collectorSupplier = collectorSupplier;
        this.internalAggregationsConsumer = internalAggregationsConsumer;
        this.reduceContextSupplier = reduceContextSupplier;
    }

    public AggregatorCollector newCollector() throws IOException {
        return this.collectorSupplier.get();
    }

    public Void reduce(Collection<AggregatorCollector> collectors) throws IOException {
        if (collectors.size() > 1) {
            ArrayList<InternalAggregations> internalAggregations = new ArrayList<InternalAggregations>(collectors.size());
            collectors.forEach(c -> internalAggregations.add(InternalAggregations.from(c.internalAggregations)));
            this.internalAggregationsConsumer.accept(InternalAggregations.topLevelReduce(internalAggregations, this.reduceContextSupplier.get()));
        } else if (collectors.size() == 1) {
            this.internalAggregationsConsumer.accept(InternalAggregations.from(collectors.iterator().next().internalAggregations));
        }
        return null;
    }
}

