/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.service;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.env.Environment;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcher;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.security.action.service.TokenInfo;
import org.elasticsearch.xpack.core.security.authc.service.NodeLocalServiceAccountTokenStore;
import org.elasticsearch.xpack.core.security.authc.service.ServiceAccount;
import org.elasticsearch.xpack.core.security.authc.service.ServiceAccountToken;
import org.elasticsearch.xpack.core.security.authc.service.ServiceAccountTokenStore;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.core.security.support.NoOpLogger;
import org.elasticsearch.xpack.security.PrivilegedFileWatcher;
import org.elasticsearch.xpack.security.authc.service.CachingServiceAccountTokenStore;
import org.elasticsearch.xpack.security.support.CacheInvalidatorRegistry;
import org.elasticsearch.xpack.security.support.FileLineParser;
import org.elasticsearch.xpack.security.support.FileReloadListener;
import org.elasticsearch.xpack.security.support.SecurityFiles;

public class FileServiceAccountTokenStore
extends CachingServiceAccountTokenStore
implements NodeLocalServiceAccountTokenStore {
    private static final Logger logger = LogManager.getLogger(FileServiceAccountTokenStore.class);
    private final Path file;
    private final ClusterService clusterService;
    private final CopyOnWriteArrayList<Runnable> refreshListeners;
    private volatile Map<String, char[]> tokenHashes;

    public FileServiceAccountTokenStore(Environment env, ResourceWatcherService resourceWatcherService, ThreadPool threadPool, ClusterService clusterService, CacheInvalidatorRegistry cacheInvalidatorRegistry) {
        super(env.settings(), threadPool);
        this.clusterService = clusterService;
        this.file = FileServiceAccountTokenStore.resolveFile(env);
        PrivilegedFileWatcher watcher = new PrivilegedFileWatcher(this.file.getParent());
        watcher.addListener(new FileReloadListener(this.file, this::tryReload));
        try {
            resourceWatcherService.add((ResourceWatcher)watcher, ResourceWatcherService.Frequency.HIGH);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to start watching service_tokens file [{}]", (Throwable)e, new Object[]{this.file.toAbsolutePath()});
        }
        try {
            this.tokenHashes = FileServiceAccountTokenStore.parseFile(this.file, logger);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load service_tokens file [" + String.valueOf(this.file) + "]", e);
        }
        this.refreshListeners = new CopyOnWriteArrayList<Runnable>(List.of(this::invalidateAll));
        cacheInvalidatorRegistry.registerCacheInvalidator("file_service_account_token", this);
    }

    @Override
    public void doAuthenticate(ServiceAccountToken token, ActionListener<ServiceAccountTokenStore.StoreAuthenticationResult> listener) {
        listener.onResponse((Object)Optional.ofNullable(this.tokenHashes.get(token.getQualifiedName())).map(hash -> ServiceAccountTokenStore.StoreAuthenticationResult.fromBooleanResult((TokenInfo.TokenSource)this.getTokenSource(), (boolean)Hasher.verifyHash((SecureString)token.getSecret(), (char[])hash))).orElse(ServiceAccountTokenStore.StoreAuthenticationResult.failed((TokenInfo.TokenSource)this.getTokenSource())));
    }

    @Override
    public TokenInfo.TokenSource getTokenSource() {
        return TokenInfo.TokenSource.FILE;
    }

    public List<TokenInfo> findNodeLocalTokensFor(ServiceAccount.ServiceAccountId accountId) {
        String principal = accountId.asPrincipal();
        return this.tokenHashes.keySet().stream().filter(k -> k.startsWith(principal + "/")).map(k -> TokenInfo.fileToken((String)Strings.substring((String)k, (int)(principal.length() + 1), (int)k.length()), List.of(this.clusterService.localNode().getName()))).toList();
    }

    public void addListener(Runnable listener) {
        this.refreshListeners.add(listener);
    }

    @Override
    public boolean shouldClearOnSecurityIndexStateChange() {
        return false;
    }

    private void notifyRefresh() {
        this.refreshListeners.forEach(Runnable::run);
    }

    private void tryReload() {
        Map<String, char[]> previousTokenHashes = this.tokenHashes;
        this.tokenHashes = FileServiceAccountTokenStore.parseFileLenient(this.file, logger);
        if (!Maps.deepEquals(this.tokenHashes, previousTokenHashes)) {
            logger.info("service tokens file [{}] changed. updating ...", (Object)this.file.toAbsolutePath());
            this.notifyRefresh();
        }
    }

    Map<String, char[]> getTokenHashes() {
        return this.tokenHashes;
    }

    static Path resolveFile(Environment env) {
        return XPackPlugin.resolveConfigFile((Environment)env, (String)"service_tokens");
    }

    static Map<String, char[]> parseFileLenient(Path path, @Nullable Logger logger) {
        try {
            return FileServiceAccountTokenStore.parseFile(path, logger);
        }
        catch (Exception e) {
            logger.error("failed to parse service tokens file [{}]. skipping/removing all tokens...", (Object)path.toAbsolutePath());
            return Map.of();
        }
    }

    static Map<String, char[]> parseFile(Path path, @Nullable Logger logger) throws IOException {
        NoOpLogger thisLogger = logger == null ? NoOpLogger.INSTANCE : logger;
        thisLogger.trace("reading service_tokens file [{}]...", (Object)path.toAbsolutePath());
        if (!Files.exists(path, new LinkOption[0])) {
            thisLogger.trace("file [{}] does not exist", (Object)path.toAbsolutePath());
            return Map.of();
        }
        HashMap parsedTokenHashes = new HashMap();
        FileLineParser.parse(path, (CheckedBiConsumer<Integer, String, IOException>)((CheckedBiConsumer)(arg_0, arg_1) -> FileServiceAccountTokenStore.lambda$parseFile$3((Logger)thisLogger, path, parsedTokenHashes, arg_0, arg_1)));
        thisLogger.debug("parsed [{}] tokens from file [{}]", (Object)parsedTokenHashes.size(), (Object)path.toAbsolutePath());
        return Map.copyOf(parsedTokenHashes);
    }

    static void writeFile(Path path, Map<String, char[]> tokenHashes) {
        SecurityFiles.writeFileAtomically(path, tokenHashes, e -> String.format(Locale.ROOT, "%s:%s", e.getKey(), new String((char[])e.getValue())));
    }

    private static /* synthetic */ void lambda$parseFile$3(Logger thisLogger, Path path, Map parsedTokenHashes, Integer lineNumber, String line) throws IOException {
        int colon = (line = line.trim()).indexOf(58);
        if (colon == -1) {
            thisLogger.warn("invalid format at line #{} of service_tokens file [{}] - missing ':' character - ", (Object)lineNumber, (Object)path);
            throw new IllegalStateException("Missing ':' character at line #" + lineNumber);
        }
        String key = line.substring(0, colon);
        char[] hash = new char[line.length() - (colon + 1)];
        line.getChars(colon + 1, line.length(), hash, 0);
        if (Hasher.resolveFromHash((char[])hash) == Hasher.NOOP) {
            thisLogger.warn("skipping plaintext service account token for key [{}]", (Object)key);
        } else {
            thisLogger.trace("parsed tokens for key [{}]", (Object)key);
            char[] previousHash = parsedTokenHashes.put(key, hash);
            if (previousHash != null) {
                thisLogger.warn("found duplicated key [{}], earlier entries are overridden", (Object)key);
            }
        }
    }
}

