/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.settings;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.logstash.settings.NullableSetting;
import org.logstash.settings.Setting;
import org.logstash.settings.SettingWithDeprecatedAlias;

public class BaseSetting<T>
implements Setting<T> {
    private String name;
    T defaultValue;
    private T value = null;
    private final boolean strict;
    private final Predicate<T> validator;
    private boolean valueIsSet = false;

    public BaseSetting<T> clone() {
        try {
            BaseSetting clone = (BaseSetting)super.clone();
            clone.value = this.value;
            clone.valueIsSet = this.valueIsSet;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public static <T> Builder<T> create(String name) {
        return new Builder(name);
    }

    protected BaseSetting(String name, boolean strict, Predicate<T> validator) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(validator);
        this.name = name;
        this.strict = strict;
        this.validator = validator;
    }

    protected BaseSetting(String name, T defaultValue, boolean strict, Predicate<T> validator) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(validator);
        this.name = name;
        this.defaultValue = defaultValue;
        this.strict = strict;
        this.validator = validator;
        if (strict) {
            this.validate(defaultValue);
        }
    }

    protected BaseSetting<T> deprecate(String deprecatedName) {
        Object clone = this.clone();
        ((BaseSetting)clone).updateName(deprecatedName);
        return clone;
    }

    private void updateName(String deprecatedName) {
        this.name = deprecatedName;
    }

    protected static <T> Predicate<T> noValidator() {
        return t -> true;
    }

    @Override
    public void validate(T input) throws IllegalArgumentException {
        if (!this.validator.test(input)) {
            throw new IllegalArgumentException("Failed to validate setting " + this.name + " with value: " + String.valueOf(input));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public T value() {
        if (this.valueIsSet) {
            return this.value;
        }
        return this.defaultValue;
    }

    @Override
    public boolean isSet() {
        return this.valueIsSet;
    }

    @Override
    public boolean isStrict() {
        return this.strict;
    }

    @Override
    public void setSafely(T newValue) {
        if (this.strict) {
            this.validate(newValue);
        }
        this.value = newValue;
        this.valueIsSet = true;
    }

    @Override
    public void reset() {
        this.value = null;
        this.valueIsSet = false;
    }

    @Override
    public void validateValue() {
        this.validate(this.value());
    }

    @Override
    public T getDefault() {
        return this.defaultValue;
    }

    @Override
    public void format(List<String> output) {
        T effectiveValue = this.value;
        String settingName = this.name;
        if (effectiveValue != null && effectiveValue.equals(this.defaultValue)) {
            output.add(String.format("%s: %s", settingName, effectiveValue));
        } else if (this.defaultValue == null) {
            output.add(String.format("*%s: %s", settingName, effectiveValue));
        } else if (effectiveValue == null) {
            output.add(String.format("%s: %s", settingName, this.defaultValue));
        } else {
            output.add(String.format("*%s: %s (default: %s)", settingName, effectiveValue, this.defaultValue));
        }
    }

    public List<Setting<T>> withDeprecatedAlias(String deprecatedAlias) {
        return this.withDeprecatedAlias(deprecatedAlias, null);
    }

    public List<Setting<T>> withDeprecatedAlias(String deprecatedAlias, String obsoletedVersion) {
        return SettingWithDeprecatedAlias.wrap(this, deprecatedAlias, obsoletedVersion);
    }

    public Setting<T> nullable() {
        return new NullableSetting(this);
    }

    public static final class Builder<T> {
        private final String name;
        private boolean strict = true;
        private T defaultValue = null;
        private Predicate<T> validator = BaseSetting.noValidator();

        public Builder(String name) {
            this.name = name;
        }

        public Builder<T> defaultValue(T defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder<T> strict(boolean strict) {
            this.strict = strict;
            return this;
        }

        public Builder<T> validator(Predicate<T> validator) {
            this.validator = validator;
            return this;
        }

        public BaseSetting<T> build() {
            return new BaseSetting<T>(this.name, this.defaultValue, this.strict, this.validator);
        }
    }
}

