"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isValidDateType = void 0;
var _moment = _interopRequireWildcard(require("moment"));
var _is_valid_numeric_type = require("./is_valid_numeric_type");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// ECS mapping date format is default optional strict-date-time and epoch ms time: "strict_date_optional_time||epoch_millis"
// https://www.elastic.co/guide/en/elasticsearch/reference/current/mapping-date-format.html#strict-date-time
const additionalFormats = ['yyyy-MM-DDT' // is valid for ES but not for moment's ISO_8601
];

/**
 * validates ES date type
 */
const isValidDateType = date => {
  // any number or string that can be parsed as valid number is a valid date for ES
  if ((0, _is_valid_numeric_type.isValidNumericType)(date)) {
    return true;
  }
  if (typeof date !== 'string') {
    return false;
  }
  return (0, _moment.default)(date, [_moment.ISO_8601, ...additionalFormats], true).isValid();
};
exports.isValidDateType = isValidDateType;