"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineEventDetailRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styles = require("../../styles");
var _stateful_row_renderer = require("../../body/events/stateful_row_renderer");
var _use_timeline_unified_data_table_context = require("./use_timeline_unified_data_table_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/unified_components/data_table/timeline_event_detail_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/** This offset begins at two, because the header row counts as "row 1", and aria-rowindex starts at "1" */
const ARIA_ROW_INDEX_OFFSET = 2;
/**
 * Renders the additional row for the timeline
 * This additional row is used to render:
 * - the row renderers
 * - the notes and text area when notes are being created.
 *
 * This components is also responsible for styling that additional row when
 * a event/alert is expanded (i.e. when flyout is open and user is viewing the details of the event)
 *
 * */
const TimelineEventDetailRow = exports.TimelineEventDetailRow = /*#__PURE__*/(0, _react.memo)(function TimelineEventDetailRow({
  rowIndex,
  event,
  setCellProps,
  timelineId,
  enabledRowRenderers
}) {
  var _ctx$expanded2;
  const containerRef = (0, _react.useRef)(null);

  /*
   * Ideally, unified data table could have handled the styling of trailing columns when a row is expanded.
   * But, a trailing column can have arbitrary design and that is why it is best for consumer to handle the styling
   * as we are doing below
   *
   * */
  const ctx = (0, _use_timeline_unified_data_table_context.useTimelineUnifiedDataTableContext)();
  (0, _react.useEffect)(() => {
    var _ctx$expanded;
    setCellProps === null || setCellProps === void 0 ? void 0 : setCellProps({
      className: ((_ctx$expanded = ctx.expanded) === null || _ctx$expanded === void 0 ? void 0 : _ctx$expanded.id) === event._id ? 'unifiedDataTable__cell--expanded' : '',
      style: {
        width: '100%',
        height: undefined,
        overflowX: 'auto'
      }
    });
  }, [(_ctx$expanded2 = ctx.expanded) === null || _ctx$expanded2 === void 0 ? void 0 : _ctx$expanded2.id, setCellProps, rowIndex, event._id]);
  if (!enabledRowRenderers || enabledRowRenderers.length === 0) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "center",
    "data-test-subj": `timeline-row-renderer-${rowIndex}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_styles.EventsTrSupplement, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_stateful_row_renderer.StatefulRowRenderer, {
    ariaRowindex: rowIndex + ARIA_ROW_INDEX_OFFSET,
    containerRef: containerRef,
    event: event,
    lastFocusedAriaColindex: rowIndex - 1,
    rowRenderers: enabledRowRenderers,
    timelineId: timelineId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 13
    }
  }))));
});