"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoteCards = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _public = require("@kbn/timelines-plugin/public");
var _add_note = require("../add_note");
var _note_previews = require("../../open_timeline/note_previews");
var i18n = _interopRequireWildcard(require("../translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/notes/note_cards/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AddNoteContainer = _styledComponents.default.div``;
AddNoteContainer.displayName = 'AddNoteContainer';
const NoteContainer = _styledComponents.default.div`
  margin-top: 5px;
`;
NoteContainer.displayName = 'NoteContainer';
const NoteCardsCompContainer = (0, _styledComponents.default)(_eui.EuiPanel)`
  border: none;
  background-color: transparent;
  box-shadow: none;

  &.euiPanel--plain {
    background-color: transparent;
  }
`;
NoteCardsCompContainer.displayName = 'NoteCardsCompContainer';
const NotesContainer = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin-bottom: 5px;
`;
NotesContainer.displayName = 'NotesContainer';
/** A view for entering and reviewing notes */
const NoteCards = exports.NoteCards = /*#__PURE__*/_react.default.memo(({
  ariaRowindex,
  associateNote,
  className,
  notes,
  showAddNote,
  toggleShowAddNote,
  eventId,
  timelineId,
  onCancel,
  showToggleEventDetailsAction = true
}) => {
  const [newNote, setNewNote] = (0, _react.useState)('');
  const associateNoteAndToggleShow = (0, _react.useCallback)(noteId => {
    associateNote(noteId);
    if (!toggleShowAddNote) return;
    if (eventId != null) {
      toggleShowAddNote(eventId);
    } else {
      toggleShowAddNote();
    }
  }, [associateNote, toggleShowAddNote, eventId]);
  const onCancelAddNote = (0, _react.useCallback)(() => {
    onCancel === null || onCancel === void 0 ? void 0 : onCancel();
    if (!toggleShowAddNote) return;
    if (eventId != null) {
      toggleShowAddNote(eventId);
    } else {
      toggleShowAddNote();
    }
  }, [eventId, toggleShowAddNote, onCancel]);
  return /*#__PURE__*/_react.default.createElement(NoteCardsCompContainer, {
    className: className,
    "data-test-subj": "note-cards",
    hasShadow: false,
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }, notes.length ? /*#__PURE__*/_react.default.createElement(_note_previews.NotePreviewsContainer, {
    "data-test-subj": "note-previews-container",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(NotesContainer, {
    className: (0, _public.getNotesContainerClassName)(ariaRowindex),
    "data-test-subj": "notes",
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    "data-test-subj": "screenReaderOnly",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 17
    }
  }, i18n.YOU_ARE_VIEWING_NOTES(ariaRowindex))), /*#__PURE__*/_react.default.createElement(_note_previews.NotePreviews, {
    timelineId: timelineId,
    notes: notes,
    showToggleEventDetailsAction: showToggleEventDetailsAction,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 15
    }
  }))) : null, showAddNote ? /*#__PURE__*/_react.default.createElement(AddNoteContainer, {
    "data-test-subj": "add-note-container",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_add_note.AddNote, {
    associateNote: associateNoteAndToggleShow,
    newNote: newNote,
    onCancelAddNote: onCancelAddNote,
    updateNewNote: setNewNote,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 13
    }
  })) : null);
});
NoteCards.displayName = 'NoteCards';