"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EVENT_START_FIELD_NAME = exports.EVENT_END_FIELD_NAME = exports.DurationEventStartEnd = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _draggables = require("../../../../common/components/draggables");
var _duration = require("../../duration");
var _formatted_date = require("../../../../common/components/formatted_date");
var _formatted_duration = require("../../formatted_duration");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/netflow/netflow_columns/duration_event_start_end.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EVENT_START_FIELD_NAME = exports.EVENT_START_FIELD_NAME = 'event.start';
const EVENT_END_FIELD_NAME = exports.EVENT_END_FIELD_NAME = 'event.end';
const TimeIcon = (0, _styledComponents.default)(_eui.EuiIcon)`
  margin-right: 3px;
  position: relative;
  top: -1px;
`;
TimeIcon.displayName = 'TimeIcon';

/**
 * Renders a column of draggable badges containing:
 * - `event.duration`
 * - `event.start`
 * - `event.end`
 */
const DurationEventStartEnd = exports.DurationEventStartEnd = /*#__PURE__*/_react.default.memo(({
  contextId,
  eventDuration,
  eventId,
  eventEnd,
  eventStart,
  scopeId
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "flexStart",
  "data-test-subj": "duration-and-start-group",
  direction: "column",
  justifyContent: "center",
  gutterSize: "none",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 43,
    columnNumber: 3
  }
}, eventDuration != null ? (0, _fp.uniq)(eventDuration).map(duration => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  key: duration,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 52,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
  scopeId: scopeId,
  field: _duration.EVENT_DURATION_FIELD_NAME,
  id: `duration-event-start-end-default-draggable-${contextId}-${eventId}-${_duration.EVENT_DURATION_FIELD_NAME}-${duration}`
  // @ts-expect-error
  ,
  name: name,
  tooltipContent: null,
  value: duration,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 53,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 62,
    columnNumber: 15
  }
}, /*#__PURE__*/_react.default.createElement(TimeIcon, {
  size: "m",
  type: "clock",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 63,
    columnNumber: 17
  }
}), /*#__PURE__*/_react.default.createElement(_formatted_duration.FormattedDuration, {
  maybeDurationNanoseconds: duration,
  tooltipTitle: _duration.EVENT_DURATION_FIELD_NAME,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 64,
    columnNumber: 17
  }
}))))) : null, eventStart != null ? (0, _fp.uniq)(eventStart).map(start => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  key: start,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 75,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
  scopeId: scopeId,
  field: EVENT_START_FIELD_NAME,
  id: `duration-event-start-end-default-draggable-${contextId}-${eventId}-${EVENT_START_FIELD_NAME}-${start}`,
  tooltipContent: null,
  value: start,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 76,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 83,
    columnNumber: 15
  }
}, /*#__PURE__*/_react.default.createElement(TimeIcon, {
  size: "m",
  type: "clock",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 84,
    columnNumber: 17
  }
}), /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
  fieldName: EVENT_START_FIELD_NAME,
  value: start,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 85,
    columnNumber: 17
  }
}))))) : null, eventEnd != null ? (0, _fp.uniq)(eventEnd).map(end => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  key: end,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 93,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
  scopeId: scopeId,
  field: EVENT_END_FIELD_NAME,
  id: `duration-event-start-end-default-draggable-${contextId}-${eventId}-${EVENT_END_FIELD_NAME}-${end}`,
  tooltipContent: null,
  value: end,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 94,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 101,
    columnNumber: 15
  }
}, /*#__PURE__*/_react.default.createElement(TimeIcon, {
  size: "m",
  type: "clock",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 102,
    columnNumber: 17
  }
}), /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
  fieldName: EVENT_END_FIELD_NAME,
  value: end,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 103,
    columnNumber: 17
  }
}))))) : null));
DurationEventStartEnd.displayName = 'DurationEventStartEnd';