"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewTimelineButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _use_create_timeline = require("../../../hooks/use_create_timeline");
var _timeline = require("../../../../../common/api/timeline");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/modal/actions/new_timeline_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Button that opens a popover with options to create a new timeline or a new timeline template
 */
const NewTimelineButton = exports.NewTimelineButton = /*#__PURE__*/_react.default.memo(({
  timelineId
}) => {
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => setPopover(prev => !prev), []);
  const createNewTimeline = (0, _use_create_timeline.useCreateTimeline)({
    timelineId,
    timelineType: _timeline.TimelineTypeEnum.default,
    onClick: togglePopover
  });
  const createNewTimelineTemplate = (0, _use_create_timeline.useCreateTimeline)({
    timelineId,
    timelineType: _timeline.TimelineTypeEnum.template,
    onClick: togglePopover
  });
  const button = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "arrowDown",
      iconSide: "right",
      "data-test-subj": 'timeline-modal-new-timeline-dropdown-button',
      onClick: togglePopover,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 7
      }
    }, i18n.NEW_TIMELINE_BTN);
  }, [togglePopover]);
  const handleCreateNewTimeline = (0, _react.useCallback)(async () => {
    await createNewTimeline();
  }, [createNewTimeline]);
  const handleCreateNewTimelineTemplate = (0, _react.useCallback)(async () => {
    await createNewTimelineTemplate();
  }, [createNewTimelineTemplate]);
  const items = (0, _react.useMemo)(() => [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "new-timeline",
    icon: "plusInCircle",
    "data-test-subj": 'timeline-modal-new-timeline',
    onClick: handleCreateNewTimeline,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, i18n.NEW_TIMELINE), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "new-timeline-template",
    icon: "plusInCircle",
    "data-test-subj": 'timeline-modal-new-timeline-template',
    onClick: handleCreateNewTimelineTemplate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, i18n.NEW_TEMPLATE_TIMELINE)], [handleCreateNewTimeline, handleCreateNewTimelineTemplate]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: togglePopover,
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: items,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }));
});
NewTimelineButton.displayName = 'NewTimelineButton';