"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultFieldRendererOverflow = exports.DefaultFieldRendererComponent = exports.DefaultFieldRenderer = exports.DEFAULT_MORE_MAX_HEIGHT = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _page = require("../../../../common/components/page");
var _draggables = require("../../../../common/components/draggables");
var _empty_value = require("../../../../common/components/empty_value");
var _helpers = require("../../../../common/components/drag_and_drop/helpers");
var _more_container = require("../more_container");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/field_renderers/default_renderer/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/** The default max-height of the popover used to show "+n More" items (e.g. `+9 More`) */
const DEFAULT_MORE_MAX_HEIGHT = exports.DEFAULT_MORE_MAX_HEIGHT = '200px';
const DefaultFieldRendererComponent = ({
  attrName,
  displayCount = 1,
  idPrefix,
  moreMaxHeight = DEFAULT_MORE_MAX_HEIGHT,
  render,
  rowItems,
  scopeId
}) => {
  if (rowItems != null && rowItems.length > 0) {
    const draggables = rowItems.slice(0, displayCount).map((rowItem, index) => {
      const id = (0, _helpers.escapeDataProviderId)(`default-field-renderer-default-draggable-${idPrefix}-${attrName}-${rowItem}`);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: id,
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 45,
          columnNumber: 9
        }
      }, index !== 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ',', /*#__PURE__*/_react.default.createElement(_page.Spacer, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 15
        }
      })), typeof rowItem === 'string' && /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
        id: id,
        field: attrName,
        value: rowItem,
        isAggregatable: true,
        scopeId: scopeId,
        fieldType: 'keyword',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 13
        }
      }, render ? render(rowItem) : rowItem));
    });
    return draggables.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      css: {
        flexGrow: 'unset'
      },
      alignItems: "center",
      gutterSize: "none",
      component: "span",
      "data-test-subj": "DefaultFieldRendererComponent",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 9
      }
    }, draggables, " "), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(DefaultFieldRendererOverflow, {
      attrName: attrName,
      idPrefix: idPrefix,
      moreMaxHeight: moreMaxHeight,
      overflowIndexStart: displayCount,
      render: render,
      rowItems: rowItems,
      scopeId: scopeId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 11
      }
    }))) : (0, _empty_value.getEmptyTagValue)();
  } else {
    return (0, _empty_value.getEmptyTagValue)();
  }
};
exports.DefaultFieldRendererComponent = DefaultFieldRendererComponent;
const DefaultFieldRenderer = exports.DefaultFieldRenderer = /*#__PURE__*/_react.default.memo(DefaultFieldRendererComponent);
DefaultFieldRenderer.displayName = 'DefaultFieldRenderer';
const DefaultFieldRendererOverflow = exports.DefaultFieldRendererOverflow = /*#__PURE__*/_react.default.memo(({
  attrName,
  idPrefix,
  moreMaxHeight,
  overflowIndexStart = 5,
  render,
  rowItems,
  scopeId
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => setIsOpen(currentIsOpen => !currentIsOpen), []);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ' ,', /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    onClick: togglePopover,
    "data-test-subj": "DefaultFieldRendererOverflow-button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }, `+${rowItems.length - overflowIndexStart} `, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.fieldRenderers.moreLabel",
    defaultMessage: "More",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 13
    }
  }))), [togglePopover, overflowIndexStart, rowItems.length]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 7
    }
  }, rowItems.length > overflowIndexStart && /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "popover",
    button: button,
    isOpen: isOpen,
    closePopover: togglePopover,
    repositionOnScroll: true,
    panelClassName: "withHoverActions__popover",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_more_container.MoreContainer, {
    fieldName: attrName,
    idPrefix: idPrefix,
    render: render,
    values: rowItems,
    overflowIndexStart: overflowIndexStart,
    scopeId: scopeId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 13
    }
  })));
});
DefaultFieldRendererOverflow.displayName = 'DefaultFieldRendererOverflow';