"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorsFieldSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _indicator = require("../../../../../../common/threat_intelligence/types/indicator");
var _styles = require("./styles");
var _test_ids = require("./test_ids");
var _translations = require("./translations");
var _use_current_data_view_fields = require("../../hooks/use_current_data_view_fields");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/indicators/components/barchart/field_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_STACK_BY_VALUE = _indicator.RawIndicatorFieldId.Feed;
const COMBOBOX_SINGLE_SELECTION = {
  asPlainText: true
};
const IndicatorsFieldSelector = exports.IndicatorsFieldSelector = /*#__PURE__*/(0, _react.memo)(({
  valueChange,
  defaultStackByValue = DEFAULT_STACK_BY_VALUE
}) => {
  const rawFields = (0, _use_current_data_view_fields.useCurrentDataViewFields)();
  const styles = (0, _styles.useStyles)();
  const defaultStackByValueInfo = rawFields.find(f => f.name === defaultStackByValue);
  const [selectedField, setSelectedField] = (0, _react.useState)([{
    label: defaultStackByValue,
    value: defaultStackByValueInfo === null || defaultStackByValueInfo === void 0 ? void 0 : defaultStackByValueInfo.type
  }]);
  const fields = (0, _react.useMemo)(() => rawFields.map(f => ({
    label: f.name,
    value: f.type
  })), [rawFields]);
  const selectedFieldChange = (0, _react.useCallback)(values => {
    if (values && values.length > 0) {
      valueChange(values[0]);
    }
    setSelectedField(values);
  }, [valueChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    css: styles.comboBox,
    "data-test-subj": _test_ids.DROPDOWN_TEST_ID,
    prepend: _translations.COMBOBOX_PREPEND_LABEL,
    singleSelection: COMBOBOX_SINGLE_SELECTION,
    onChange: selectedFieldChange,
    options: fields,
    selectedOptions: selectedField,
    isClearable: false,
    "aria-label": _translations.COMBOBOX_PREPEND_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  });
});
IndicatorsFieldSelector.displayName = 'IndicatorsFieldSelector';