"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorsBarChart = void 0;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _chartsTheme = require("@kbn/charts-theme");
var _i18n = require("@kbn/i18n");
var _legend_action = require("./legend_action");
var _dates = require("../../../../utils/dates");
var _use_kibana_ui_settings = require("../../../../hooks/use_kibana_ui_settings");
var _use_screen_reader_context = require("../../hooks/use_screen_reader_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/indicators/components/barchart/barchart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ID = 'tiIndicator';
const DEFAULT_CHART_HEIGHT = '200px';
const DEFAULT_CHART_WIDTH = '100%';
const DEFAULT_LEGEND_SIZE = 200;
/**
 * Displays a barchart of aggregated indicators using the @elastic/charts library.
 */
const IndicatorsBarChart = ({
  indicators,
  dateRange,
  field,
  height = DEFAULT_CHART_HEIGHT
}) => {
  const chartBaseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const timeZone = (0, _use_kibana_ui_settings.useTimeZone)();
  const {
    announce
  } = (0, _use_screen_reader_context.useScreenReaderAnnouncements)();
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      width: DEFAULT_CHART_WIDTH,
      height
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: chartBaseTheme,
    showLegend: true,
    legendPosition: _charts.Position.Right,
    legendSize: DEFAULT_LEGEND_SIZE,
    legendAction: ({
      label
    }) => /*#__PURE__*/_react.default.createElement(_legend_action.IndicatorBarchartLegendAction, {
      announceIndicatorActionChange: announce,
      field: field,
      data: label,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 11
      }
    }),
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: `${ID}TimeAxis`,
    position: _charts.Position.Bottom,
    tickFormat: (0, _dates.barChartTimeAxisLabelFormatter)(dateRange),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: `${ID}IndicatorAxis`,
    position: _charts.Position.Left,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: `${ID}BarChart`,
    name: "Indicators"
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "x",
    yAccessors: ['y'],
    stackAccessors: ['x'],
    splitSeriesAccessors: ['g'],
    data: indicators,
    timeZone: timeZone,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }));
};
exports.IndicatorsBarChart = IndicatorsBarChart;