"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UploadDashboardsSectionPanel = exports.UploadDashboardsPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _icon = require("../../../common/icon");
var i18n = _interopRequireWildcard(require("./translations"));
var _styles = require("../../../common/styles");
var _upload_panel = require("../../../common/styles/upload_panel.styles");
var _components = require("../../../common/components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/dashboards/components/status_panels/upload_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UploadDashboardsSectionPanel = exports.UploadDashboardsSectionPanel = /*#__PURE__*/_react.default.memo(function UploadDashboardsSectionPanel({
  isUploadMore = false,
  isDisabled = false,
  onOpenFlyout
}) {
  const styles = (0, _upload_panel.useUploadPanelStyles)(isUploadMore);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: isUploadMore ? 'm' : 'l',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    className: styles,
    gutterSize: isUploadMore ? 'm' : 'l',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_icon.SiemMigrationsIcon, {
    className: "siemMigrationsIcon",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  }, isUploadMore ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: _styles.START_MIGRATION_TITLE_CLASS_NAME,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 17
    }
  }, i18n.START_DASHBOARD_MIGRATION_CARD_UPLOAD_MORE_TITLE)) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    className: _styles.START_MIGRATION_TITLE_CLASS_NAME,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 21
    }
  }, i18n.START_DASHBOARD_MIGRATION_CARD_UPLOAD_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 21
    }
  }, i18n.START_DASHBOARD_MIGRATION_CARD_UPLOAD_DESCRIPTION))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_components.MigrationsReadMore, {
    migrationType: "dashboard",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 11
    }
  }, isUploadMore ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "startDashboardMigrationUploadMoreButton",
    iconType: "download",
    iconSide: "right",
    onClick: onOpenFlyout,
    isDisabled: isDisabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 15
    }
  }, i18n.START_DASHBOARD_MIGRATION_CARD_UPLOAD_MORE_BUTTON) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "startDashboardMigrationUploadDashboardsButton",
    iconType: "download",
    iconSide: "right",
    onClick: onOpenFlyout,
    isDisabled: isDisabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 15
    }
  }, i18n.START_DASHBOARD_MIGRATION_CARD_UPLOAD_BUTTON))));
});
const UploadDashboardsPanel = exports.UploadDashboardsPanel = /*#__PURE__*/_react.default.memo(function UploadDashboardsPanel({
  isUploadMore = false,
  isDisabled = false,
  migrationStats
}) {
  const {
    openFlyout
  } = (0, _components.useMigrationDataInputContext)();
  const onOpenFlyout = (0, _react.useCallback)(() => {
    openFlyout(migrationStats);
  }, [openFlyout, migrationStats]);
  return /*#__PURE__*/_react.default.createElement(UploadDashboardsSectionPanel, {
    isDisabled: isDisabled,
    isUploadMore: isUploadMore,
    onOpenFlyout: onOpenFlyout,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  });
});
UploadDashboardsPanel.displayName = 'UploadDashboardsPanel';