"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DateSelectionButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _super_date_picker = require("../../../common/components/super_date_picker");
var _styles = require("./styles");
var _use_colors = require("../use_colors");
var selectors = _interopRequireWildcard(require("../../store/selectors"));
var _action = require("../../store/data/action");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/resolver/view/controls/date_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const emptyRanges = [];
const nodeLegendButtonTitle = _i18n.i18n.translate('xpack.securitySolution.resolver.graphControls.datePickerButtonTitle', {
  defaultMessage: 'Date Range Selection'
});
const dateRangeDescription = _i18n.i18n.translate('xpack.securitySolution.resolver.graphControls.datePicker', {
  defaultMessage: 'date range selection'
});
const DateSelectionButton = exports.DateSelectionButton = /*#__PURE__*/(0, _react.memo)(({
  id,
  closePopover,
  setActivePopover,
  isOpen
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const setAsActivePopover = (0, _react.useCallback)(() => setActivePopover('datePicker'), [setActivePopover]);
  const colorMap = (0, _use_colors.useColors)();
  const appliedBounds = (0, _reactRedux.useSelector)(state => {
    return selectors.currentAppliedTimeRange(state.analyzer[id]);
  });
  const onTimeChange = (0, _react.useCallback)(({
    start,
    end,
    isInvalid
  }) => {
    if (!isInvalid) {
      const isQuickSelection = start.includes('now') || end.includes('now');
      const fromDate = (0, _super_date_picker.formatDate)(start);
      let toDate = (0, _super_date_picker.formatDate)(end, {
        roundUp: true
      });
      if (isQuickSelection) {
        if (start === end) {
          toDate = (0, _super_date_picker.formatDate)('now');
        } else {
          toDate = (0, _super_date_picker.formatDate)(end);
        }
      }
      dispatch((0, _action.userOverrodeDateRange)({
        id,
        timeRange: {
          from: fromDate,
          to: toDate
        }
      }));
    }
  }, [dispatch, id]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_styles.StyledEuiButtonIcon, {
      "data-test-subj": "resolver:graph-controls:date-picker-button",
      size: "m",
      title: nodeLegendButtonTitle,
      "aria-label": nodeLegendButtonTitle,
      onClick: setAsActivePopover,
      iconType: "calendar",
      $backgroundColor: colorMap.graphControlsBackground,
      $iconColor: colorMap.graphControls,
      $borderColor: colorMap.graphControlsBorderColor,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 11
      }
    }),
    isOpen: isOpen,
    closePopover: closePopover,
    anchorPosition: "leftCenter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    css: {
      textTransform: 'uppercase'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }, dateRangeDescription), /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    onTimeChange: onTimeChange,
    start: appliedBounds === null || appliedBounds === void 0 ? void 0 : appliedBounds.from,
    end: appliedBounds === null || appliedBounds === void 0 ? void 0 : appliedBounds.to,
    showUpdateButton: false,
    recentlyUsedRanges: emptyRanges,
    width: "auto",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }));
});
DateSelectionButton.displayName = 'DateSelectionButton';