"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentlessAvailableCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _kibana = require("../../../../../../../common/lib/kibana");
var _links = require("../../../../../../../common/components/links");
var _card_callout = require("../../card_callout");
var _constants = require("../constants");
var _integration_context = require("../../../../../../../common/lib/integrations/hooks/integration_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/onboarding/components/onboarding_body/cards/common/integrations/callouts/agentless_available_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AgentlessAvailableCallout = exports.AgentlessAvailableCallout = /*#__PURE__*/_react.default.memo(() => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  const {
    telemetry: {
      reportLinkClick
    }
  } = (0, _integration_context.useIntegrationContext)();
  const onClick = (0, _react.useCallback)(() => {
    reportLinkClick === null || reportLinkClick === void 0 ? void 0 : reportLinkClick(_constants.TELEMETRY_AGENTLESS_LEARN_MORE);
  }, [reportLinkClick]);

  /* @ts-expect-error: add the blog link to `packages/kbn-doc-links/src/get_doc_links.ts` when it is ready and remove this exit condition*/
  if (!docLinks.links.fleet.agentlessBlog) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_card_callout.CardCallOut, {
    color: "danger",
    text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.onboarding.integrationsCard.callout.agentLessAvailableLabel",
      defaultMessage: `{icon} {new} {text} {link}`,
      values: {
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "cheer",
          size: "m",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 43,
            columnNumber: 19
          }
        }),
        new: /*#__PURE__*/_react.default.createElement("b", {
          css: (0, _react2.css)`
                  font-weight: ${euiTheme.font.weight.bold};
                `,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 45,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.onboarding.integrationsCard.callout.agentLessAvailableNewLabel",
          defaultMessage: "NEW",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 50,
            columnNumber: 17
          }
        })),
        text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.onboarding.integrationsCard.callout.agentLessAvailableText",
          defaultMessage: "Identify configuration risks in your cloud account with new and simplified agentless configuration",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 57,
            columnNumber: 15
          }
        }),
        link: /*#__PURE__*/_react.default.createElement(_links.LinkAnchor
        /* @ts-expect-error-next-line */, {
          href: docLinks.links.fleet.agentlessBlog,
          onClick: onClick,
          "data-test-subj": "agentlessLearnMoreLink",
          external: true,
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 63,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.onboarding.integrationsCard.button.agentlessLearnMoreLink",
          defaultMessage: "Learn more",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 71,
            columnNumber: 17
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  });
});
AgentlessAvailableCallout.displayName = 'AgentlessAvailableCallout';