"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinuxEventCollectionCard = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _i18n = require("@kbn/i18n");
var _event_collection_card = require("../event_collection_card");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/policy_settings_form/components/cards/linux_event_collection_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OPTIONS = [{
  name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.linux.events.file', {
    defaultMessage: 'File'
  }),
  protectionField: 'file'
}, {
  name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.linux.events.network', {
    defaultMessage: 'Network'
  }),
  protectionField: 'network'
}, {
  name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.linux.events.process', {
    defaultMessage: 'Process'
  }),
  protectionField: 'process'
}];
const SUPPLEMENTAL_OPTIONS = [{
  id: 'sessionDataSection',
  title: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.linux.events.session_data.title', {
    defaultMessage: 'Session data'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.linux.events.session_data.description', {
    defaultMessage: 'Turn this on to capture the extended process data required for Session View. Session View provides you a visual representation of session and process execution data. Session View data is organized according to the Linux process model to help you investigate process, user, and service activity on your Linux infrastructure.'
  }),
  name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.linux.events.session_data.label', {
    defaultMessage: 'Collect session data'
  }),
  protectionField: 'session_data',
  isDisabled: config => {
    return !config.linux.events.process;
  }
}, {
  name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.linux.events.tty_io.label', {
    defaultMessage: 'Capture terminal output'
  }),
  protectionField: 'tty_io',
  tooltipText: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.linux.events.tty_io.tooltip', {
    defaultMessage: 'Turn this on to collect terminal (tty) output. Terminal output appears in Session View, and you can view it separately to see what commands were executed and how they were typed, provided the terminal is in echo mode. Only works on hosts that support ebpf.'
  }),
  indented: true,
  isDisabled: config => {
    return !config.linux.events.session_data;
  }
}];
const LinuxEventCollectionCard = exports.LinuxEventCollectionCard = /*#__PURE__*/(0, _react.memo)(({
  onChange,
  mode,
  ...restProps
}) => {
  const supplementalOptions = (0, _react.useMemo)(() => {
    if (mode === 'edit') {
      return SUPPLEMENTAL_OPTIONS;
    }

    // View only mode: remove instructions for session data
    return SUPPLEMENTAL_OPTIONS.map(option => {
      if (option.id === 'sessionDataSection') {
        return {
          ...option,
          description: undefined
        };
      }
      return option;
    });
  }, [mode]);
  const changeHandler = (0, _react.useCallback)(({
    isValid,
    updatedPolicy
  }) => {
    if (isValid && updatedPolicy.linux.events.session_data === false) {
      updatedPolicy.linux.events.tty_io = false;
    }
    onChange({
      isValid,
      updatedPolicy
    });
  }, [onChange]);
  return /*#__PURE__*/_react.default.createElement(_event_collection_card.EventCollectionCard, (0, _extends2.default)({}, restProps, {
    mode: mode,
    onChange: changeHandler,
    os: _securitysolutionUtils.OperatingSystem.LINUX,
    selection: restProps.policy.linux.events,
    supplementalOptions: supplementalOptions,
    options: OPTIONS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }));
});
LinuxEventCollectionCard.displayName = 'LinuxEventCollectionCard';