"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowInsightsIncompatibleAntivirusResult = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _user_privileges = require("../../../../../../../../common/components/user_privileges");
var _kibana = require("../../../../../../../../common/lib/kibana");
var _constants = require("../../../../../../../../../common/constants");
var _translations = require("../../../../translations");
var _routing = require("../../../../../../../common/routing");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/endpoint_hosts/view/details/components/insights/results/incompatible_antivirus.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WorkflowInsightsIncompatibleAntivirusResult = ({
  insight,
  index,
  endpointId
}) => {
  var _insight$remediation$;
  const {
    ariaLabel,
    actionText,
    tooltipContent,
    tooltipNoPermissions
  } = _translations.WORKFLOW_INSIGHTS.issues.remediationButton.incompatibleAntivirus;
  const {
    canWriteTrustedApplications
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const {
    application: {
      navigateToUrl
    }
  } = (0, _kibana.useKibana)().services;
  const openArtifactCreationPage = (0, _react.useCallback)(({
    remediation,
    id
  }) => {
    const getUrlBasedOnListId = listId => {
      switch (listId) {
        case _securitysolutionListConstants.ENDPOINT_ARTIFACT_LISTS.trustedApps.id:
        default:
          return _constants.TRUSTED_APPS_PATH;
      }
    };
    const url = `${_constants.APP_PATH}${getUrlBasedOnListId(remediation.list_id)}?show=create`;
    const state = {
      insight: {
        id,
        back_url: `${_constants.APP_PATH}${(0, _routing.getEndpointDetailsPath)({
          name: 'endpointDetails',
          selected_endpoint: endpointId
        })}`,
        item: {
          comments: [],
          description: remediation.description,
          entries: remediation.entries,
          list_id: remediation.list_id,
          name: remediation.name,
          namespace_type: 'agnostic',
          tags: remediation.tags,
          type: 'simple',
          os_types: remediation.os_types
        }
      }
    };
    navigateToUrl(url, {
      state
    });
  }, [endpointId, navigateToUrl]);
  return ((_insight$remediation$ = insight.remediation.exception_list_items) !== null && _insight$remediation$ !== void 0 ? _insight$remediation$ : []).map(exceptionListItem => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      paddingSize: "m",
      hasShadow: false,
      hasBorder: true,
      key: index,
      "data-test-subj": `workflowInsightsResult-${index}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: 'center',
      gutterSize: 'm',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "securityApp",
      size: "l",
      color: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: 's',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 17
      }
    }, insight.metadata.display_name || insight.value)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: 's',
      color: 'subdued',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 15
      }
    }, insight.message), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: 'xs',
      color: 'subdued',
      css: {
        wordBreak: 'break-word'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 15
      }
    }, exceptionListItem.entries[0].type === 'match' && exceptionListItem.entries[0].field === 'process.executable.caseless' && exceptionListItem.entries[0].value))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      css: {
        marginLeft: 'auto'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: canWriteTrustedApplications ? tooltipContent : tooltipNoPermissions,
      position: 'top',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": `workflowInsightsResult-${index}-remediation`,
      isDisabled: !canWriteTrustedApplications,
      "aria-label": ariaLabel,
      iconType: "plusInCircle",
      href: `${_constants.APP_PATH}${_constants.TRUSTED_APPS_PATH}?show=create`,
      onClick: e => {
        e.preventDefault();
        if (insight.id) {
          openArtifactCreationPage({
            remediation: exceptionListItem,
            id: insight.id
          });
        }
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 15
      }
    }, actionText)))));
  });
};
exports.WorkflowInsightsIncompatibleAntivirusResult = WorkflowInsightsIncompatibleAntivirusResult;