"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RunningProcessesActionResults = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _css = require("@emotion/css");
var _user_privileges = require("../../../common/components/user_privileges");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
var _response_action_file_download_link = require("../response_action_file_download_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/running_processes_action_results/running_processes_action_results.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RunningProcessesActionResults = exports.RunningProcessesActionResults = /*#__PURE__*/(0, _react.memo)(({
  action,
  agentId,
  textSize = 's',
  'data-test-subj': dataTestSubj
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: textSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }, action.agentType === 'endpoint' ? /*#__PURE__*/_react.default.createElement(EndpointRunningProcessesResults, {
    action: action,
    agentId: agentId,
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 11
    }
  }) : action.agentType === 'sentinel_one' ? /*#__PURE__*/_react.default.createElement(SentinelOneRunningProcessesResults, {
    action: action,
    agentId: agentId,
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 11
    }
  }) : null);
});
RunningProcessesActionResults.displayName = 'RunningProcessesActionResults';

// @ts-expect-error TS2769
const StyledEuiBasicTable = (0, _styledComponents.default)(_eui.EuiBasicTable)`
  table {
    background-color: transparent;
    font-size: inherit;
  }

  .euiTableHeaderCell {
    border-bottom: ${props => props.theme.eui.euiBorderThin};

    .euiTableCellContent__text {
      font-weight: ${props => props.theme.eui.euiFontWeightRegular};
    }
  }

  .euiTableRow {
    &:hover {
      background-color: ${({
  theme: {
    eui
  }
}) => eui.euiColorEmptyShade} !important;
    }

    .euiTableRowCell {
      border-top: none !important;
      border-bottom: none !important;
    }
  }
`;
/** @internal */
const EndpointRunningProcessesResults = /*#__PURE__*/(0, _react.memo)(({
  action,
  agentId,
  'data-test-subj': dataTestSubj
}) => {
  var _action$outputs$agent, _action$outputs2, _action$outputs2$agen;
  const testId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const agentIds = agentId ? [agentId] : [...action.agents];
  const columns = (0, _react.useMemo)(() => [{
    field: 'user',
    'data-test-subj': testId('user'),
    name: _i18n.i18n.translate('xpack.securitySolution.endpointResponseActions.getProcesses.table.header.user', {
      defaultMessage: 'USER'
    }),
    width: '10%'
  }, {
    field: 'pid',
    'data-test-subj': testId('pid'),
    name: _i18n.i18n.translate('xpack.securitySolution.endpointResponseActions.getProcesses.table.header.pid', {
      defaultMessage: 'PID'
    }),
    width: '5%'
  }, {
    field: 'entity_id',
    'data-test-subj': testId('entity_id'),
    name: _i18n.i18n.translate('xpack.securitySolution.endpointResponseActions.getProcesses.table.header.enityId', {
      defaultMessage: 'ENTITY ID'
    }),
    width: '30%'
  }, {
    field: 'command',
    'data-test-subj': testId('command'),
    name: _i18n.i18n.translate('xpack.securitySolution.endpointResponseActions.getProcesses.table.header.command', {
      defaultMessage: 'COMMAND'
    }),
    width: '55%'
  }], [testId]);
  const wrappingClassname = (0, _react.useMemo)(() => {
    return (0, _css.css)({
      '.accordion-host-name-button-content': {
        fontSize: 'inherit'
      }
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": testId(),
    className: wrappingClassname,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  }, agentIds.length > 1 ? agentIds.map(id => {
    var _action$outputs$id$co, _action$outputs, _action$outputs$id;
    const hostName = action.hosts[id].name;
    return /*#__PURE__*/_react.default.createElement("div", {
      key: hostName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(HostProcessesAccordion, {
      buttonContent: /*#__PURE__*/_react.default.createElement(HostNameHeader, {
        hostName: hostName,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 157,
          columnNumber: 34
        }
      }),
      "data-test-subj": testId('hostOutput'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(StyledEuiBasicTable, {
      "data-test-subj": testId('processListTable'),
      items: (_action$outputs$id$co = (_action$outputs = action.outputs) === null || _action$outputs === void 0 ? void 0 : (_action$outputs$id = _action$outputs[id]) === null || _action$outputs$id === void 0 ? void 0 : _action$outputs$id.content.entries) !== null && _action$outputs$id$co !== void 0 ? _action$outputs$id$co : [],
      columns: columns,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 17
      }
    }));
  }) : /*#__PURE__*/_react.default.createElement(StyledEuiBasicTable, {
    "data-test-subj": testId('processListTable'),
    items: (_action$outputs$agent = (_action$outputs2 = action.outputs) === null || _action$outputs2 === void 0 ? void 0 : (_action$outputs2$agen = _action$outputs2[agentIds[0]]) === null || _action$outputs2$agen === void 0 ? void 0 : _action$outputs2$agen.content.entries) !== null && _action$outputs$agent !== void 0 ? _action$outputs$agent : [],
    columns: columns,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 11
    }
  }));
});
EndpointRunningProcessesResults.displayName = 'EndpointRunningProcessesResults';
/** @internal */
const SentinelOneRunningProcessesResults = /*#__PURE__*/(0, _react.memo)(({
  action,
  agentId,
  'data-test-subj': dataTestSubj
}) => {
  const testId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const agentIds = agentId ? [agentId] : action.agents;
  const {
    canGetRunningProcesses
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;

  // If user is not allowed to execute the running processes response action (but may still have
  // access to the Response Actions history log), then we don't show any results because user
  // does not have access to the file download apis.
  if (!canGetRunningProcesses) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 7
    }
  }, agentIds.length === 1 ? /*#__PURE__*/_react.default.createElement(_response_action_file_download_link.ResponseActionFileDownloadLink, {
    action: action,
    canAccessFileDownloadLink: true,
    showPasscode: false,
    "data-test-subj": testId('download'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 11
    }
  }) : agentIds.map(id => {
    const hostName = action.hosts[id].name;
    return /*#__PURE__*/_react.default.createElement("div", {
      key: id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(HostProcessesAccordion, {
      buttonContent: /*#__PURE__*/_react.default.createElement(HostNameHeader, {
        hostName: hostName,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 224,
          columnNumber: 34
        }
      }),
      "data-test-subj": testId('hostOutput'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_response_action_file_download_link.ResponseActionFileDownloadLink, {
      action: action,
      agentId: id,
      canAccessFileDownloadLink: canGetRunningProcesses,
      showPasscode: false,
      "data-test-subj": testId('download'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 236,
        columnNumber: 17
      }
    }));
  }));
});
SentinelOneRunningProcessesResults.displayName = 'SentinelOneRunningProcessesResults';
const HostNameHeader = /*#__PURE__*/(0, _react.memo)(({
  hostName
}) => {
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.runningProcessesActionResults.accordionHostName",
    defaultMessage: "Host: {hostName}",
    values: {
      hostName
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 5
    }
  });
});
HostNameHeader.displayName = 'HostNameHeader';
const HostProcessesAccordion = /*#__PURE__*/(0, _react.memo)(({
  buttonContent,
  'data-test-subj': dataTestSubj,
  children
}) => {
  const htmlId = (0, _eui.useGeneratedHtmlId)();

  // FYI: Class name used below is defined at the top-level - under component `RunningProcessesActionResults`
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: `ProcessesOutput_${htmlId}`,
    initialIsOpen: false,
    paddingSize: "s",
    "data-test-subj": dataTestSubj,
    buttonClassName: "accordion-host-name-button-content",
    buttonContent: buttonContent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 7
    }
  }, children);
});
HostProcessesAccordion.displayName = 'HostProcessesAccordion';