"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicySelectorMenuButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
var _policy_selector = require("./policy_selector");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/policy_selector/policy_selector_menu_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * A policy selector button - user is shown the list of policies when they click on the button.
 * Count of selections are reflected on the button.
 */
const PolicySelectorMenuButton = exports.PolicySelectorMenuButton = /*#__PURE__*/(0, _react.memo)(props => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [countOfPolicies, setCountOfPolicies] = (0, _react.useState)(0);
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(props['data-test-subj']);
  const countOfSelectedPolicies = (0, _react.useMemo)(() => {
    var _props$additionalList;
    return props.selectedPolicyIds.length + ((_props$additionalList = props.additionalListItems) !== null && _props$additionalList !== void 0 ? _props$additionalList : []).filter(additionalItem => additionalItem.checked === 'on').length;
  }, [props.additionalListItems, props.selectedPolicyIds.length]);
  const onFetch = (0, _react.useCallback)(fetchedData => {
    const {
      type,
      filtered,
      data
    } = fetchedData;
    if (type === 'search' && !filtered) {
      var _props$additionalList2;
      setCountOfPolicies(data.total + ((_props$additionalList2 = props.additionalListItems) !== null && _props$additionalList2 !== void 0 ? _props$additionalList2 : []).length);
    }
    if (props.onFetch) {
      props.onFetch(fetchedData);
    }
  }, [props]);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    iconType: "arrowDown",
    "data-test-subj": getTestId(),
    onClick: () => {
      setIsPopoverOpen(prevState => !prevState);
    },
    isSelected: isPopoverOpen,
    numFilters: countOfPolicies > 0 ? countOfPolicies : undefined,
    hasActiveFilters: countOfSelectedPolicies > 0,
    numActiveFilters: countOfSelectedPolicies,
    disabled: props.isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.management.policiesSelector.label",
    defaultMessage: "Policies",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 11
    }
  }))), [getTestId, isPopoverOpen, countOfPolicies, countOfSelectedPolicies, props.isDisabled]);
  const closePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_policy_selector.PolicySelector, (0, _extends2.default)({}, props, {
    onFetch: onFetch,
    "data-test-subj": getTestId('policySelector'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }))));
});
PolicySelectorMenuButton.displayName = 'PolicySelectorMenuButton';