"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToTestId = exports.CommandList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _use_data_test_subj = require("../hooks/state_selectors/use_data_test_subj");
var _use_console_state_dispatch = require("../hooks/state_selectors/use_console_state_dispatch");
var _builtin_commands = require("../service/builtin_commands");
var _utils = require("../service/utils");
var _console_code_block = require("./console_code_block");
var _kibana = require("../../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/console/components/command_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const otherCommandsGroupLabel = _i18n.i18n.translate('xpack.securitySolution.console.commandList.otherCommandsGroup.label', {
  defaultMessage: 'Other commands'
});

/**
 * Takes a string and removes all non-letters/number from it.
 * @param value
 */
const convertToTestId = value => {
  return value.replace(/[^A-Za-z0-9]/g, '');
};

// @ts-expect-error TS2769
exports.convertToTestId = convertToTestId;
const StyledEuiBasicTable = (0, _styledComponents.default)(_eui.EuiBasicTable)`
  margin-top: ${({
  theme: {
    eui
  }
}) => eui.euiSizeS};
  .euiTableHeaderCell {
    .euiTableCellContent__text {
      color: ${({
  theme: {
    eui
  }
}) => eui.euiTextColor};
      font-size: ${({
  theme: {
    eui
  }
}) => eui.euiFontSize};
      padding-bottom: ${({
  theme: {
    eui
  }
}) => eui.euiSizeS};
      padding-left: ${({
  theme: {
    eui
  }
}) => eui.euiSizeS};
    }
  }
`;
const StyledEuiCallOut = (0, _styledComponents.default)(_eui.EuiCallOut)`
  margin: ${({
  theme: {
    eui
  }
}) => eui.euiSize};
  padding: ${({
  theme: {
    eui
  }
}) => eui.euiSize};
  border-radius: ${({
  theme: {
    eui
  }
}) => eui.euiSizeXS};
`;
const StyledEuiFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  padding-left: ${({
  theme: {
    eui
  }
}) => eui.euiSizeS};
`;
const StyledEuiFlexGrid = (0, _styledComponents.default)(_eui.EuiFlexGrid)`
  @media only screen and (min-width: ${props => props.theme.eui.euiBreakpoints.l}) {
    max-width: 75%;
  }
  @media only screen and (min-width: ${props => props.theme.eui.euiBreakpoints.xl}) {
    max-width: 50%;
  }
`;
const StyledEuiBadge = (0, _styledComponents.default)(_eui.EuiBadge)`
  font-size: 10px !important;
  span {
    color: ${({
  theme: {
    eui
  }
}) => eui.euiShadowColor} !important;
  }
`;
const CommandList = exports.CommandList = /*#__PURE__*/(0, _react.memo)(({
  commands,
  display = 'default'
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)((0, _use_data_test_subj.useDataTestSubj)('commandList'));
  const dispatch = (0, _use_console_state_dispatch.useConsoleStateDispatch)();
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  const footerMessage = (0, _react.useMemo)(() => {
    var _COMMON_ARGS$find;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      compressed: true,
      listItems: [{
        title: /*#__PURE__*/_react.default.createElement(StyledEuiBadge, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 107,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
          inline: true,
          bold: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 108,
            columnNumber: 17
          }
        }, (_COMMON_ARGS$find = _builtin_commands.COMMON_ARGS.find(current => current.name === '--help')) === null || _COMMON_ARGS$find === void 0 ? void 0 : _COMMON_ARGS$find.name)),
        description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          color: "subdued",
          size: "xs",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 114,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.console.commandList.footerText",
          defaultMessage: "For more help with the individual commands use the --help argument. Ex: processes --help",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 115,
            columnNumber: 17
          }
        }))
      }],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 7
      }
    });
  }, []);
  const updateInputText = (0, _react.useCallback)(text => () => {
    dispatch({
      type: 'updateInputTextEnteredState',
      payload: () => {
        return {
          leftOfCursorText: text,
          rightOfCursorText: ''
        };
      }
    });
    dispatch({
      type: 'addFocusToKeyCapture'
    });
  }, [dispatch]);
  const commandsByGroups = (0, _react.useMemo)(() => {
    const helpGroups = new Map();

    // We only show commands that are no hidden
    const allowedCommands = commands.filter(command => command.helpHidden !== true);
    for (const allowedCommand of allowedCommands) {
      const {
        helpGroupLabel = otherCommandsGroupLabel,
        helpGroupPosition = Infinity
      } = allowedCommand;
      const groupEntry = helpGroups.get(helpGroupLabel);
      if (groupEntry) {
        groupEntry.list.push(allowedCommand);

        // Its possible (but probably not intentionally) that the same Group Label might
        // have different positions defined (ex. one has a position, and another does not,
        // which defaults to `Infinity`. If we detect that here, then update the group
        // position. In the end, the group label will have the last explicitly defined
        // position found.
        if (groupEntry.position === Infinity && helpGroupPosition !== undefined && helpGroupPosition !== groupEntry.position) {
          groupEntry.position = helpGroupPosition;
        }
      } else {
        helpGroups.set(allowedCommand.helpGroupLabel, {
          label: helpGroupLabel,
          position: helpGroupPosition,
          list: [allowedCommand]
        });
      }
    }

    // Sort by Group position and return an array of arrays with the list of commands per group
    return (0, _lodash.sortBy)(Array.from(helpGroups.values()), 'position').map(group => {
      // ensure all commands in this group have a `helpCommandPosition`. Those missing one, will
      // be set to `Infinity` so that they are moved to the end.
      const groupCommandList = group.list.map(command => {
        if (command.helpCommandPosition === undefined) {
          return {
            ...command,
            helpCommandPosition: Infinity
          };
        }
        return command;
      });
      return (0, _lodash.sortBy)(groupCommandList, 'helpCommandPosition');
    });
  }, [commands]);
  const getTableItems = (0, _react.useCallback)(commandsByGroup => {
    if (commandsByGroup[0].helpGroupLabel === _builtin_commands.HELP_GROUPS.supporting.label) {
      return [..._builtin_commands.COMMON_ARGS, ...commandsByGroup].map(command => {
        var _commandsByGroup$0$he, _commandsByGroup$;
        return {
          [(_commandsByGroup$0$he = (_commandsByGroup$ = commandsByGroup[0]) === null || _commandsByGroup$ === void 0 ? void 0 : _commandsByGroup$.helpGroupLabel) !== null && _commandsByGroup$0$he !== void 0 ? _commandsByGroup$0$he : otherCommandsGroupLabel]: command
        };
      });
    }
    return commandsByGroup.map(command => {
      var _commandsByGroup$0$he2, _commandsByGroup$2;
      return {
        [(_commandsByGroup$0$he2 = (_commandsByGroup$2 = commandsByGroup[0]) === null || _commandsByGroup$2 === void 0 ? void 0 : _commandsByGroup$2.helpGroupLabel) !== null && _commandsByGroup$0$he2 !== void 0 ? _commandsByGroup$0$he2 : otherCommandsGroupLabel]: command
      };
    });
  }, []);
  const getTableColumns = (0, _react.useCallback)(commandsByGroup => {
    var _commandsByGroup$0$he3, _commandsByGroup$3;
    const groupLabel = (_commandsByGroup$0$he3 = (_commandsByGroup$3 = commandsByGroup[0]) === null || _commandsByGroup$3 === void 0 ? void 0 : _commandsByGroup$3.helpGroupLabel) !== null && _commandsByGroup$0$he3 !== void 0 ? _commandsByGroup$0$he3 : otherCommandsGroupLabel;
    const groupTestIdSuffix = convertToTestId(groupLabel);
    return [{
      field: groupLabel,
      name: /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": getTestId('group'),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 228,
          columnNumber: 17
        }
      }, groupLabel),
      render: command => {
        const commandNameWithArgs = (0, _utils.getCommandNameWithArgs)(command);
        return /*#__PURE__*/_react.default.createElement(StyledEuiFlexGroup, {
          alignItems: "center",
          "data-test-subj": getTestId(`${groupTestIdSuffix}-${command.name}`),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 232,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: 1,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 236,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
          "data-test-subj": getTestId('command'),
          listItems: [{
            title: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
              "data-test-subj": getTestId('commandName'),
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 242,
                columnNumber: 27
              }
            }, commandNameWithArgs),
            description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
              size: "xs",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 248,
                columnNumber: 29
              }
            }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
              color: "subdued",
              size: "xs",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 249,
                columnNumber: 29
              }
            }, command.about))
          }],
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 237,
            columnNumber: 19
          }
        })), command.helpGroupLabel !== _builtin_commands.HELP_GROUPS.supporting.label && command.helpHidden !== true && command.RenderComponent && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 261,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: command.helpDisabled === true ? _i18n.i18n.translate('xpack.securitySolution.console.commandList.disabledButtonTooltip', {
            defaultMessage: 'Unsupported command'
          }) : _i18n.i18n.translate('xpack.securitySolution.console.commandList.addButtonTooltip', {
            defaultMessage: 'Add to text bar'
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 262,
            columnNumber: 23
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          iconType: "plusInCircle",
          "aria-label": `updateTextInputCommand-${command.name}`,
          onClick: updateInputText(`${commandNameWithArgs} `),
          isDisabled: command.helpDisabled === true,
          "data-test-subj": getTestId(`${groupTestIdSuffix}-${command.name}-addToInput`),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 275,
            columnNumber: 25
          }
        }))));
      }
    }];
  }, [getTestId, updateInputText]);
  const getFilteredCommands = (0, _react.useCallback)(commandsByGroup => commandsByGroup.filter(current => current.name !== 'help' && current.name !== 'clear'), []);
  if (display === 'table') {
    const calloutItems = [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.console.commandList.callout.multipleResponses",
      defaultMessage: "You can enter consecutive response actions \u2014 no need to wait for previous actions to complete.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 306,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.console.commandList.callout.leavingResponder",
      defaultMessage: "Leaving the response console does not terminate any actions that have been submitted.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 310,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.console.commandList.callout.visitSupportSections",
      defaultMessage: "{learnMore} about response actions and using the console.",
      values: {
        learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.securitySolution.responseActions,
          target: "_blank",
          "data-test-subj": getTestId('helpfulHintDocLink'),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 319,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.console.commandList.callout.readMoreLink",
          defaultMessage: "Learn more",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 324,
            columnNumber: 15
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 314,
        columnNumber: 7
      }
    })];
    const callout = /*#__PURE__*/_react.default.createElement(StyledEuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.console.commandList.callout.title",
        defaultMessage: "Helpful tips:",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 337,
          columnNumber: 11
        }
      }),
      "data-test-subj": getTestId('helpfulTips'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 335,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("ul", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 344,
        columnNumber: 9
      }
    }, calloutItems.map((item, index) => /*#__PURE__*/_react.default.createElement("li", {
      key: index,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 346,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 347,
        columnNumber: 15
      }
    }, item)))));
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": getTestId(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 355,
        columnNumber: 7
      }
    }, commandsByGroups.map((commandsByGroup, i) => {
      var _commandsByGroup$0$he4;
      return /*#__PURE__*/_react.default.createElement(StyledEuiBasicTable, {
        "data-test-subj": getTestId(convertToTestId((_commandsByGroup$0$he4 = commandsByGroup[0].helpGroupLabel) !== null && _commandsByGroup$0$he4 !== void 0 ? _commandsByGroup$0$he4 : otherCommandsGroupLabel)),
        key: `styledEuiBasicTable-${i}`,
        items: getTableItems(commandsByGroup),
        columns: getTableColumns(commandsByGroup),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 357,
          columnNumber: 11
        }
      });
    }), callout);
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": getTestId(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 372,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 373,
      columnNumber: 7
    }
  }), commandsByGroups.map(commandsByGroup => {
    const groupLabel = commandsByGroup[0].helpGroupLabel;
    const filteredCommands = getFilteredCommands(commandsByGroup);
    if (filteredCommands.length === 0) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(StyledEuiFlexGrid, {
      columns: 3,
      responsive: false,
      gutterSize: "l",
      key: groupLabel,
      direction: "column",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 383,
        columnNumber: 11
      }
    }, filteredCommands.map(command => {
      const commandNameWithArgs = (0, _utils.getCommandNameWithArgs)(command);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: command.name,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 393,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
        compressed: true,
        listItems: [{
          title: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            content: commandNameWithArgs,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 399,
              columnNumber: 27
            }
          }, /*#__PURE__*/_react.default.createElement(StyledEuiBadge, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 400,
              columnNumber: 29
            }
          }, /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
            inline: true,
            bold: true,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 401,
              columnNumber: 31
            }
          }, commandNameWithArgs))),
          description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            color: "subdued",
            size: "xs",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 408,
              columnNumber: 27
            }
          }, command.about)
        }],
        "data-test-subj": getTestId('command'),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 394,
          columnNumber: 19
        }
      }));
    }));
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 422,
      columnNumber: 7
    }
  }), footerMessage);
});
CommandList.displayName = 'CommandList';