"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InputDisplay = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_console_state_dispatch = require("../../../hooks/state_selectors/use_console_state_dispatch");
var _use_with_input_text_entered = require("../../../hooks/state_selectors/use_with_input_text_entered");
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
var _use_data_test_subj = require("../../../hooks/state_selectors/use_data_test_subj");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/console/components/command_input/components/input_display.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SCROLLING_PADDING = 20;
const InputDisplayContainer = _styledComponents.default.div`
  overflow: hidden !important;

  .inputDisplay {
    & > * {
      flex-direction: row;
      align-items: center;
    }
  }

  // Styles for when the console's input has focus are defined in '<CommandInput>' component
  .cursor {
    display: inline-block;
    width: 1px;
    height: ${({
  theme: {
    eui
  }
}) => eui.euiLineHeight}em;
    background-color: ${({
  theme
}) => theme.eui.euiTextSubduedColor};
  }
`;
const InputDisplay = exports.InputDisplay = /*#__PURE__*/(0, _react.memo)(({
  leftOfCursor,
  rightOfCursor
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)((0, _use_data_test_subj.useDataTestSubj)());
  const dispatch = (0, _use_console_state_dispatch.useConsoleStateDispatch)();
  const {
    leftOfCursorText,
    fullTextEntered
  } = (0, _use_with_input_text_entered.useWithInputTextEntered)();
  const observer = (0, _react.useRef)(null);
  const containerRef = (0, _react.useRef)(null);
  const cursorRef = (0, _react.useRef)(null);
  const currentCursorPosition = leftOfCursorText.length;
  const handleSingleClick = (0, _react.useCallback)(ev => {
    const clickedTarget = ev.target;

    // Handle moving the cursor to the click position
    if (fullTextEntered.length && clickedTarget.classList && clickedTarget.classList.contains('chr')) {
      const allInputChars = Array.from(ev.currentTarget.querySelectorAll('span.chr'));
      const newCursorPosition = allInputChars.indexOf(clickedTarget);
      const newLeftOfCursorText = fullTextEntered.substring(0, newCursorPosition + 1);
      const newRightOfCursorText = fullTextEntered.substring(newCursorPosition + 1);

      // reset input
      dispatch({
        type: 'updateInputTextEnteredState',
        payload: {
          leftOfCursorText: newLeftOfCursorText,
          rightOfCursorText: newRightOfCursorText
        }
      });
    }
  }, [dispatch, fullTextEntered]);

  // Setup the Intersection observer
  (0, _react.useEffect)(() => {
    if (containerRef.current) {
      const handleIntersection = entries => {
        if (containerRef.current) {
          const intersection = entries[0];
          if (intersection && intersection.rootBounds) {
            const currentScrollLeftValue = containerRef.current.scrollLeft;
            const viewportRightEdge = intersection.rootBounds.right;
            const viewportLeftEdge = intersection.rootBounds.left;
            const cursorPosition = intersection.boundingClientRect.right;
            if (cursorPosition > viewportRightEdge - SCROLLING_PADDING) {
              // cursor is close to the Right Edge of the display input area.
              // scroll right so that cursor remains visible.
              const newScrollLeftValue = currentScrollLeftValue + (cursorPosition - intersection.rootBounds.width) + SCROLLING_PADDING;
              containerRef.current.scrollLeft = newScrollLeftValue;
            } else if (cursorPosition < viewportLeftEdge + SCROLLING_PADDING) {
              // cursor is close to the Left edge of the display input area.
              // scroll left so that cursor remains visible;
              const newScrollLeftValue = cursorPosition - SCROLLING_PADDING < 0 ? 0 : currentScrollLeftValue - SCROLLING_PADDING;
              containerRef.current.scrollLeft = newScrollLeftValue;
            }
          }
        }
      };
      observer.current = new IntersectionObserver(handleIntersection, {
        root: containerRef.current,
        // The `-10px` ensure that the observer is triggered when the cursor is within
        // 10px of the edge of the viewport (the scrolling container).
        rootMargin: '0px -10px',
        threshold: 0
      });
      return () => {
        var _observer$current;
        (_observer$current = observer.current) === null || _observer$current === void 0 ? void 0 : _observer$current.disconnect();
        observer.current = null;
      };
    }
  }, []);

  // Anytime the cursor position changes, re-observe the movement of the cursor.
  (0, _react.useEffect)(() => {
    if (observer.current && cursorRef.current) {
      const intersectionObserver = observer.current;
      const cursorEle = cursorRef.current;
      intersectionObserver.observe(cursorEle);
      return () => {
        intersectionObserver.unobserve(cursorEle);
      };
    }
  }, [currentCursorPosition]);
  return /*#__PURE__*/_react.default.createElement(InputDisplayContainer, {
    ref: containerRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    gutterSize: "none",
    className: "inputDisplay",
    onClick: handleSingleClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": getTestId('cmdInput-leftOfCursor'),
    className: "noMinWidth",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 9
    }
  }, leftOfCursor), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "noMinWidth",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "cursor essentialAnimation",
    ref: cursorRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "noMinWidth",
    "data-test-subj": getTestId('cmdInput-rightOfCursor'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 9
    }
  }, rightOfCursor)));
});
InputDisplay.displayName = 'InputDisplay';