"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InputAreaPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
var _command_input_history = require("./command_input_history");
var _use_console_state_dispatch = require("../../../hooks/state_selectors/use_console_state_dispatch");
var _use_with_input_show_popover = require("../../../hooks/state_selectors/use_with_input_show_popover");
var _use_data_test_subj = require("../../../hooks/state_selectors/use_data_test_subj");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/console/components/command_input/components/input_area_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const InputAreaPopover = exports.InputAreaPopover = /*#__PURE__*/(0, _react.memo)(({
  children,
  width = '92vw'
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)((0, _use_data_test_subj.useDataTestSubj)());
  const show = (0, _use_with_input_show_popover.useWithInputShowPopover)();
  const isPopoverOpen = show !== undefined;
  const dispatch = (0, _use_console_state_dispatch.useConsoleStateDispatch)();
  const popoverPanelStyles = (0, _react.useMemo)(() => {
    return {
      width,
      borderBottomLeftRadius: 0,
      borderBottomRightRadius: 0
    };
  }, [width]);
  const focusTrapProps = (0, _react.useMemo)(() => {
    return {
      clickOutsideDisables: true
    };
  }, []);
  const handlePopoverOnClose = (0, _react.useCallback)(() => {
    dispatch({
      type: 'updateInputPopoverState',
      payload: {
        show: undefined
      }
    });
    dispatch({
      type: 'addFocusToKeyCapture'
    });
  }, [dispatch]);
  (0, _react.useEffect)(() => {
    // Anytime the popover is closed, focus on Input area
    if (!show) {
      dispatch({
        type: 'addFocusToKeyCapture'
      });
    }
  }, [dispatch, show]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: children,
    closePopover: handlePopoverOnClose,
    isOpen: isPopoverOpen,
    panelStyle: popoverPanelStyles,
    anchorPosition: "upLeft",
    hasArrow: false,
    display: "block",
    attachToAnchor: true,
    focusTrapProps: focusTrapProps,
    ownFocus: false,
    "data-test-subj": getTestId('inputPopover'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, show && /*#__PURE__*/_react.default.createElement(_eui.EuiFocusTrap, {
    clickOutsideDisables: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, show === 'input-history' && /*#__PURE__*/_react.default.createElement(_command_input_history.CommandInputHistory, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 40
    }
  })));
});
InputAreaPopover.displayName = 'InputAreaPopover';