"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigationGuide = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _use_investigation_guide = require("../../shared/hooks/use_investigation_guide");
var _context = require("../../shared/context");
var _left = require("../../left");
var _test_ids = require("./test_ids");
var _use_navigate_to_left_panel = require("../../shared/hooks/use_navigate_to_left_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/investigation_guide.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Render either the investigation guide button that opens Investigation section in the left panel,
 * or a no-data message if investigation guide hasn't been set up on the rule
 */
const InvestigationGuide = () => {
  const {
    dataFormattedForFieldBrowser,
    isRulePreview
  } = (0, _context.useDocumentDetailsContext)();
  const {
    loading,
    error,
    basicAlertData,
    ruleNote
  } = (0, _use_investigation_guide.useInvestigationGuide)({
    dataFormattedForFieldBrowser
  });
  const {
    navigateToLeftPanel: goToInvestigationsTab,
    isEnabled: isLinkEnabled
  } = (0, _use_navigate_to_left_panel.useNavigateToLeftPanel)({
    tab: _left.LeftPanelInvestigationTab
  });
  const hasInvestigationGuide = (0, _react.useMemo)(() => !error && basicAlertData && basicAlertData.ruleId && ruleNote, [error, basicAlertData, ruleNote]);
  const content = (0, _react.useMemo)(() => {
    if (isRulePreview) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        iconType: "documentation",
        size: "s",
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.flyout.right.investigation.investigationGuide.previewTitle",
          defaultMessage: "Investigation guide",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 49,
            columnNumber: 13
          }
        }),
        "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.right.investigation.investigationGuide.previewAriaLabel', {
          defaultMessage: 'Investigation guide'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 45,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.investigation.investigationGuide.previewMessage",
        defaultMessage: "Investigation guide is not available in alert preview.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 59,
          columnNumber: 11
        }
      }));
    }
    if (loading) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
        "data-test-subj": _test_ids.INVESTIGATION_GUIDE_LOADING_TEST_ID,
        contentAriaLabel: _i18n.i18n.translate('xpack.securitySolution.flyout.right.investigation.investigationGuide.investigationGuideLoadingAriaLabel', {
          defaultMessage: 'investigation guide'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 9
        }
      });
    }
    if (hasInvestigationGuide && !isLinkEnabled) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        iconType: "documentation",
        size: "s",
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.flyout.right.investigation.investigationGuide.openFlyoutTitle",
          defaultMessage: "Investigation guide available",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 85,
            columnNumber: 13
          }
        }),
        "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.right.investigation.investigationGuide.openFlyoutAriaLabel', {
          defaultMessage: 'Investigation guide available'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.investigation.investigationGuide.openFlyoutMessage",
        defaultMessage: "Open alert details to access investigation guides.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 95,
          columnNumber: 11
        }
      }));
    }
    if (hasInvestigationGuide) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: goToInvestigationsTab,
        iconType: "documentation",
        size: "s",
        fullWidth: true,
        "data-test-subj": _test_ids.INVESTIGATION_GUIDE_BUTTON_TEST_ID,
        "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.right.investigation.investigationGuide.investigationGuideButtonAriaLabel', {
          defaultMessage: 'Show investigation guide'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.investigation.investigationGuide.investigationGuideButtonLabel",
        defaultMessage: "Show investigation guide",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 11
        }
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      iconType: "documentation",
      size: "s",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.investigation.investigationGuide.noDataTitle",
        defaultMessage: "Investigation guide",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 129,
          columnNumber: 11
        }
      }),
      "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.right.investigation.investigationGuide.noDataAriaLabel', {
        defaultMessage: 'Investigation guide'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.right.investigation.investigationGuide.noDataDescription",
      defaultMessage: "There's no investigation guide for this rule.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 9
      }
    }));
  }, [isRulePreview, loading, hasInvestigationGuide, isLinkEnabled, goToInvestigationsTab]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.INVESTIGATION_GUIDE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 10
    }
  }, content);
};
exports.InvestigationGuide = InvestigationGuide;
InvestigationGuide.displayName = 'InvestigationGuideButton';