"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelatedAlertsBySameSourceEvent = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _use_fetch_related_alerts_by_same_source_event = require("../../shared/hooks/use_fetch_related_alerts_by_same_source_event");
var _test_ids = require("./test_ids");
var _correlations_details_alerts_table = require("./correlations_details_alerts_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/left/components/related_alerts_by_same_source_event.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Show related alerts by same source event in an expandable panel with a table
 */
const RelatedAlertsBySameSourceEvent = ({
  originalEventId,
  scopeId,
  eventId
}) => {
  const {
    loading,
    data,
    dataCount
  } = (0, _use_fetch_related_alerts_by_same_source_event.useFetchRelatedAlertsBySameSourceEvent)({
    originalEventId,
    scopeId
  });
  return /*#__PURE__*/_react.default.createElement(_correlations_details_alerts_table.CorrelationsDetailsAlertsTable, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.correlations.sourceAlertsTitle",
      defaultMessage: "{count} {count, plural, one {alert} other {alerts}} related by source event",
      values: {
        count: dataCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 9
      }
    }),
    loading: loading,
    alertIds: data,
    scopeId: scopeId,
    eventId: eventId,
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.correlations.sourceAlertsNoDataDescription",
      defaultMessage: "No related source events.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 9
      }
    }),
    "data-test-subj": _test_ids.CORRELATIONS_DETAILS_BY_SOURCE_SECTION_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  });
};
exports.RelatedAlertsBySameSourceEvent = RelatedAlertsBySameSourceEvent;
RelatedAlertsBySameSourceEvent.displayName = 'RelatedAlertsBySameSourceEvent';