"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkDetailsTabs = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _eui = require("@elastic/eui");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _anomalies_network_table = require("../../../../common/components/ml/tables/anomalies_network_table");
var _network = require("../../../../../common/search_strategy/security_solution/network");
var _events_query_tab_body = require("../../../../common/components/events_tab/events_query_tab_body");
var _anomalies_query_tab_body = require("../../../../common/containers/anomalies/anomalies_query_tab_body");
var _constants = require("../constants");
var _navigation = require("../navigation");
var _conditional_flex_group = require("../navigation/conditional_flex_group");
var _store = require("../../store");
var _types = require("./types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/pages/details/details_tabs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NetworkDetailsTabs = exports.NetworkDetailsTabs = /*#__PURE__*/_react.default.memo(({
  flowTarget,
  indexPattern,
  networkDetailsFilter,
  ...rest
}) => {
  const type = _store.networkModel.NetworkType.details;
  const commonProps = {
    ...rest,
    type
  };
  const flowTabProps = {
    ...commonProps,
    indexPattern
  };
  const commonPropsWithFlowTarget = {
    ...commonProps,
    flowTarget
  };
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.NETWORK_DETAILS_PAGE_PATH}/:flowTarget/:tabName(${_types.NetworkDetailsRouteType.flows})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_conditional_flex_group.ConditionalFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_navigation.IPsQueryTabBody, (0, _extends2.default)({}, flowTabProps, {
    flowTarget: _network.FlowTargetSourceDest.source,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_navigation.IPsQueryTabBody, (0, _extends2.default)({}, flowTabProps, {
    flowTarget: _network.FlowTargetSourceDest.destination,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_conditional_flex_group.ConditionalFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_navigation.CountriesQueryTabBody, (0, _extends2.default)({}, flowTabProps, {
    flowTarget: _network.FlowTargetSourceDest.source,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_navigation.CountriesQueryTabBody, (0, _extends2.default)({}, flowTabProps, {
    flowTarget: _network.FlowTargetSourceDest.destination,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 17
    }
  })))))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.NETWORK_DETAILS_PAGE_PATH}/:flowTarget/:tabName(${_types.NetworkDetailsRouteType.users})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_navigation.UsersQueryTabBody, (0, _extends2.default)({}, commonPropsWithFlowTarget, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.NETWORK_DETAILS_PAGE_PATH}/:flowTarget/:tabName(${_types.NetworkDetailsRouteType.http})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_navigation.HttpQueryTabBody, (0, _extends2.default)({}, commonProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.NETWORK_DETAILS_PAGE_PATH}/:flowTarget/:tabName(${_types.NetworkDetailsRouteType.tls})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_navigation.TlsQueryTabBody, (0, _extends2.default)({}, commonPropsWithFlowTarget, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.NETWORK_DETAILS_PAGE_PATH}/:flowTarget/:tabName(${_types.NetworkDetailsRouteType.anomalies})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_anomalies_query_tab_body.AnomaliesQueryTabBody, (0, _extends2.default)({}, commonPropsWithFlowTarget, {
    hideHistogramIfEmpty: true,
    AnomaliesTableComponent: _anomalies_network_table.AnomaliesNetworkTable,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.NETWORK_DETAILS_PAGE_PATH}/:flowTarget/:tabName(${_types.NetworkDetailsRouteType.events})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_events_query_tab_body.EventsQueryTabBody, (0, _extends2.default)({
    additionalFilters: networkDetailsFilter
  }, commonProps, {
    tableId: _securitysolutionDataTable.TableId.networkPageEvents,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 11
    }
  }))));
});
NetworkDetailsTabs.displayName = 'UsersDetailsTabs';