"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tlsTableId = exports.TlsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _store = require("../../store");
var _search_strategy = require("../../../../../common/search_strategy");
var _use_selector = require("../../../../common/hooks/use_selector");
var _paginated_table = require("../../../components/paginated_table");
var _columns = require("./columns");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/components/tls_table/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const rowItems = [{
  text: i18n.ROWS_5,
  numberOfRow: 5
}, {
  text: i18n.ROWS_10,
  numberOfRow: 10
}];
const tlsTableId = exports.tlsTableId = 'tls-table';
const TlsTableComponent = ({
  data,
  fakeTotalCount,
  id,
  isInspect,
  loading,
  loadPage,
  setQuerySkip,
  showMorePagesIndicator,
  totalCount,
  type
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getTlsSelector = (0, _react.useMemo)(() => _store.networkSelectors.tlsSelector(), []);
  const {
    activePage,
    limit,
    sort
  } = (0, _use_selector.useDeepEqualSelector)(state => getTlsSelector(state, type));
  const tableType = type === _store.networkModel.NetworkType.page ? _store.networkModel.NetworkTableType.tls : _store.networkModel.NetworkDetailsTableType.tls;
  const updateLimitPagination = (0, _react.useCallback)(newLimit => dispatch(_store.networkActions.updateNetworkTable({
    networkType: type,
    tableType,
    updates: {
      limit: newLimit
    }
  })), [dispatch, type, tableType]);
  const updateActivePage = (0, _react.useCallback)(newPage => dispatch(_store.networkActions.updateNetworkTable({
    networkType: type,
    tableType,
    updates: {
      activePage: newPage
    }
  })), [dispatch, type, tableType]);
  const onChange = (0, _react.useCallback)(criteria => {
    if (criteria.sort != null) {
      const splitField = criteria.sort.field.split('.');
      const newTlsSort = {
        field: getSortFromString(splitField[splitField.length - 1]),
        direction: criteria.sort.direction
      };
      if (!(0, _fastDeepEqual.default)(newTlsSort, sort)) {
        dispatch(_store.networkActions.updateNetworkTable({
          networkType: type,
          tableType,
          updates: {
            sort: newTlsSort
          }
        }));
      }
    }
  }, [sort, dispatch, type, tableType]);
  const columns = (0, _react.useMemo)(() => (0, _columns.getTlsColumns)(tlsTableId), []);
  return /*#__PURE__*/_react.default.createElement(_paginated_table.PaginatedTable, {
    activePage: activePage,
    columns: columns,
    dataTestSubj: `table-${tableType}`,
    showMorePagesIndicator: showMorePagesIndicator,
    headerCount: totalCount,
    headerTitle: i18n.TRANSPORT_LAYER_SECURITY,
    headerUnit: i18n.UNIT(totalCount),
    id: id,
    isInspect: isInspect,
    itemsPerRow: rowItems,
    limit: limit,
    loading: loading,
    loadPage: loadPage,
    onChange: onChange,
    pageOfItems: data,
    setQuerySkip: setQuerySkip,
    sorting: getSortField(sort),
    totalCount: fakeTotalCount,
    updateActivePage: updateActivePage,
    updateLimitPagination: updateLimitPagination,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 5
    }
  });
};
TlsTableComponent.displayName = 'TlsTableComponent';
const TlsTable = exports.TlsTable = /*#__PURE__*/_react.default.memo(TlsTableComponent);
const getSortField = sortField => ({
  field: `node.${sortField.field}`,
  direction: sortField.direction
});
const getSortFromString = sortField => {
  switch (sortField) {
    case '_id':
      return _search_strategy.NetworkTlsFields._id;
    default:
      return _search_strategy.NetworkTlsFields._id;
  }
};