"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Network = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _direction = require("../direction");
var _draggables = require("../../../../common/components/draggables");
var i18n = _interopRequireWildcard(require("./translations"));
var _field_names = require("./field_names");
var _formatted_bytes = require("../../../../common/components/formatted_bytes");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/components/source_destination/network.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EuiFlexItemMarginRight = (0, _styled.default)(_eui.EuiFlexItem)`
  margin-right: 3px;
`;
EuiFlexItemMarginRight.displayName = 'EuiFlexItemMarginRight';
const Stats = (0, _styled.default)(_eui.EuiText)`
  margin: 0 5px;
`;
Stats.displayName = 'Stats';

/**
 * Renders a row of draggable badges containing fields from the
 * `Network` category of fields
 */
const Network = exports.Network = /*#__PURE__*/_react.default.memo(({
  bytes,
  communityId,
  contextId,
  direction,
  eventId,
  packets,
  protocol,
  transport,
  scopeId
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  justifyContent: "center",
  gutterSize: "none",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 64,
    columnNumber: 5
  }
}, direction != null ? (0, _fp.uniq)(direction).map(dir => /*#__PURE__*/_react.default.createElement(EuiFlexItemMarginRight, {
  grow: false,
  key: dir,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 67,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement(_direction.DirectionBadge, {
  scopeId: scopeId,
  contextId: contextId,
  direction: dir,
  eventId: eventId,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 68,
    columnNumber: 15
  }
}))) : null, protocol != null ? (0, _fp.uniq)(protocol).map(proto => /*#__PURE__*/_react.default.createElement(EuiFlexItemMarginRight, {
  grow: false,
  key: proto,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 80,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
  contextId: contextId,
  scopeId: scopeId,
  eventId: eventId,
  field: _field_names.NETWORK_PROTOCOL_FIELD_NAME,
  value: proto,
  isAggregatable: true,
  fieldType: "keyword",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 81,
    columnNumber: 15
  }
}))) : null, bytes != null ? (0, _fp.uniq)(bytes).map(b => !isNaN(Number(b)) ? /*#__PURE__*/_react.default.createElement(EuiFlexItemMarginRight, {
  grow: false,
  key: b,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 97,
    columnNumber: 15
  }
}, /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
  scopeId: scopeId,
  field: _field_names.NETWORK_BYTES_FIELD_NAME,
  id: `network-default-draggable-${contextId}-${eventId}-${_field_names.NETWORK_BYTES_FIELD_NAME}-${b}`,
  value: b,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 98,
    columnNumber: 17
  }
}, /*#__PURE__*/_react.default.createElement(Stats, {
  size: "xs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 104,
    columnNumber: 19
  }
}, /*#__PURE__*/_react.default.createElement("span", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 105,
    columnNumber: 21
  }
}, /*#__PURE__*/_react.default.createElement(_formatted_bytes.PreferenceFormattedBytes, {
  value: b,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 106,
    columnNumber: 23
  }
}))))) : null) : null, packets != null ? (0, _fp.uniq)(packets).map(p => /*#__PURE__*/_react.default.createElement(EuiFlexItemMarginRight, {
  grow: false,
  key: p,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 117,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
  scopeId: scopeId,
  field: _field_names.NETWORK_PACKETS_FIELD_NAME,
  id: `network-default-draggable-${contextId}-${eventId}-${_field_names.NETWORK_PACKETS_FIELD_NAME}-${p}`,
  value: p,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 118,
    columnNumber: 15
  }
}, /*#__PURE__*/_react.default.createElement(Stats, {
  size: "xs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 124,
    columnNumber: 17
  }
}, /*#__PURE__*/_react.default.createElement("span", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 125,
    columnNumber: 19
  }
}, `${p} ${i18n.PACKETS}`))))) : null, transport != null ? (0, _fp.uniq)(transport).map(trans => /*#__PURE__*/_react.default.createElement(EuiFlexItemMarginRight, {
  grow: false,
  key: trans,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 134,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
  scopeId: scopeId,
  contextId: contextId,
  "data-test-subj": "network-transport",
  eventId: eventId,
  field: _field_names.NETWORK_TRANSPORT_FIELD_NAME,
  value: trans,
  isAggregatable: true,
  fieldType: "keyword",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 135,
    columnNumber: 15
  }
}))) : null, communityId != null ? (0, _fp.uniq)(communityId).map(trans => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  key: trans,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 151,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
  scopeId: scopeId,
  contextId: contextId,
  eventId: eventId,
  field: _field_names.NETWORK_COMMUNITY_ID_FIELD_NAME,
  value: trans,
  isAggregatable: true,
  fieldType: "keyword",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 152,
    columnNumber: 15
  }
}))) : null));
Network.displayName = 'Network';