"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNIT = exports.SOURCE_IPS = exports.SOURCE_IP = exports.ROWS_5 = exports.ROWS_10 = exports.IP_TITLE = exports.FLOWS = exports.DOMAIN = exports.DESTINATION_IPS = exports.DESTINATION_IP = exports.BYTES_OUT = exports.BYTES_IN = exports.AUTONOMOUS_SYSTEM = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UNIT = totalCount => _i18n.i18n.translate('xpack.securitySolution.networkTopNFlowTable.unit', {
  values: {
    totalCount
  },
  defaultMessage: `{totalCount, plural, =1 {IP} other {IPs}}`
});
exports.UNIT = UNIT;
const SOURCE_IP = exports.SOURCE_IP = _i18n.i18n.translate('xpack.securitySolution.networkTopNFlowTable.column.sourceIpTitle', {
  defaultMessage: 'Source IPs'
});
const DESTINATION_IP = exports.DESTINATION_IP = _i18n.i18n.translate('xpack.securitySolution.networkTopNFlowTable.column.destinationIpTitle', {
  defaultMessage: 'Destination IPs'
});
const IP_TITLE = exports.IP_TITLE = _i18n.i18n.translate('xpack.securitySolution.networkTopNFlowTable.column.IpTitle', {
  defaultMessage: 'IP'
});
const DOMAIN = exports.DOMAIN = _i18n.i18n.translate('xpack.securitySolution.networkTopNFlowTable.column.domainTitle', {
  defaultMessage: 'Domain'
});
const BYTES_IN = exports.BYTES_IN = _i18n.i18n.translate('xpack.securitySolution.networkTopNFlowTable.column.bytesInTitle', {
  defaultMessage: 'Bytes in'
});
const BYTES_OUT = exports.BYTES_OUT = _i18n.i18n.translate('xpack.securitySolution.networkTopNFlowTable.column.bytesOutTitle', {
  defaultMessage: 'Bytes out'
});
const AUTONOMOUS_SYSTEM = exports.AUTONOMOUS_SYSTEM = _i18n.i18n.translate('xpack.securitySolution.networkTopNFlowTable.column.asTitle', {
  defaultMessage: 'Autonomous system'
});
const FLOWS = exports.FLOWS = _i18n.i18n.translate('xpack.securitySolution.networkTopNFlowTable.flows', {
  defaultMessage: 'Flows'
});
const DESTINATION_IPS = exports.DESTINATION_IPS = _i18n.i18n.translate('xpack.securitySolution.networkTopNFlowTable.destinationIps', {
  defaultMessage: 'Destination IPs'
});
const SOURCE_IPS = exports.SOURCE_IPS = _i18n.i18n.translate('xpack.securitySolution.networkTopNFlowTable.sourceIps', {
  defaultMessage: 'Source IPs'
});
const ROWS_5 = exports.ROWS_5 = _i18n.i18n.translate('xpack.securitySolution.networkTopNFlowTable.rows', {
  values: {
    numRows: 5
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});
const ROWS_10 = exports.ROWS_10 = _i18n.i18n.translate('xpack.securitySolution.networkTopNFlowTable.rows', {
  values: {
    numRows: 10
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});